/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.protocol;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kd.bos.xcache.server.common.ReferenceCounted;
import kd.bos.xcache.server.protocol.ValueType;

public class Value<T>
implements ReferenceCounted {
    private ValueType type;
    private T value;
    public static final Value NULL = new Value<Object>(ValueType.NULL, null);
    public static final Value<Long> LONG_ZERO = new Value<Long>(ValueType.LONG, 0L);
    public static final Value<Long> LONG_ONE = new Value<Long>(ValueType.LONG, 1L);

    private Value(ValueType type, T value) {
        this.type = type;
        this.value = value;
    }

    public ValueType getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public static Value newString(String value) {
        return new Value<String>(ValueType.STRING, value);
    }

    public static Value newLong(long value) {
        return new Value<Long>(ValueType.LONG, value);
    }

    public static Value newBytes(byte[] bytes) {
        return new Value<byte[]>(ValueType.BYTES, bytes);
    }

    public static Value newBytes(String string) {
        return new Value<byte[]>(ValueType.BYTES, string.getBytes(StandardCharsets.UTF_8));
    }

    public static Value newBuffer(ByteBuf buffer) {
        return new Value<ByteBuf>(ValueType.BUFFER, buffer);
    }

    public static Value newList(List<Value> values) {
        return new Value<List<Value>>(ValueType.LIST, values);
    }

    public boolean isNull() {
        return this == NULL;
    }

    public String getString() {
        return (String)this.value;
    }

    public Long getLong() {
        return (Long)this.value;
    }

    public byte[] getBytes() {
        return (byte[])this.value;
    }

    public ByteBuf getBuffer() {
        return (ByteBuf)this.value;
    }

    public List<Value> getList() {
        return (List)this.value;
    }

    @Override
    public void retain() {
        if (this.type == ValueType.BUFFER) {
            this.getBuffer().retain();
        }
    }

    @Override
    public void release() {
        if (this.type == ValueType.BUFFER) {
            this.getBuffer().release();
        }
    }
}

