/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.result.handler;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.xcache.server.result.Results;
import kd.bos.xcache.server.result.handler.ResultHandler;
import kd.bos.xcache.server.result.model.Result;

public class ResultMergeHandler
implements ResultHandler {
    private final AtomicInteger total;
    private final Queue<Result> results;
    private final boolean sumMode;

    public ResultMergeHandler(int totalResult, boolean sumMode) {
        this.total = new AtomicInteger(totalResult);
        this.results = new LinkedBlockingQueue<Result>(totalResult);
        this.sumMode = sumMode;
    }

    @Override
    public void handle(Result result, List<Result> out) {
        this.results.add(result);
        if (this.total.decrementAndGet() <= 0) {
            this.doHandler(out);
        }
    }

    private void doHandler(List<Result> out) {
        LinkedList<Result> allResult = new LinkedList<Result>();
        while (!this.results.isEmpty()) {
            allResult.add(this.results.poll());
        }
        out.add(this.sumMode ? Results.convertors().sum(allResult) : Results.convertors().merge(allResult));
    }
}

