/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.result.handler;

import java.util.List;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.net.ClientInfo;
import kd.bos.xcache.server.result.handler.ResultHandler;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.slowlog.SlowLogManger;

public class SlowLogHandler
implements ResultHandler {
    private final long beginNacos;
    private final ClientInfo client;
    private final Command command;

    public SlowLogHandler(ClientInfo client, Command command) {
        this.beginNacos = command.createTimeInNanos();
        this.client = client;
        this.command = command;
    }

    @Override
    public void handle(Result result, List<Result> out) {
        long costMirco = (System.nanoTime() - this.beginNacos) / 1000L;
        if (SlowLogManger.isSlowLog(costMirco)) {
            SlowLogManger.addSlowLog(costMirco, this.command, this.client.getHost(), this.client.getPort());
        }
        out.add(result);
    }
}

