/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.result.model;

import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.result.model.MultiValueResult;
import kd.bos.xcache.server.result.model.NoValueResult;
import kd.bos.xcache.server.result.model.Result;
import kd.bos.xcache.server.result.model.SingleValueResult;

public class SuccessValueBuilder {
    private static final UnaryOperator<Value> VALUE_CHECKER = v -> v == null ? Value.NULL : v;

    public static SuccessValueBuilder newBuilder() {
        return new SuccessValueBuilder();
    }

    public NoValueResult andReturnOperationOK() {
        NoValueResult result = new NoValueResult();
        result.status = 0;
        return result;
    }

    public SingleValueResult andReturn(Value data) {
        SingleValueResult result = new SingleValueResult();
        result.status = 0;
        result.data = VALUE_CHECKER.apply(data);
        return result;
    }

    public SingleValueResult andReturnEmpty() {
        return this.andReturn(Value.NULL);
    }

    public Result andReturnEmptyArray() {
        return this.doReturnArray(Collections.emptyList());
    }

    public Result andReturnArray(List<Value> data) {
        if (data == null) {
            return this.andReturnEmptyArray();
        }
        return this.doReturnArray(data);
    }

    private Result doReturnArray(List<Value> data) {
        MultiValueResult result = new MultiValueResult();
        result.status = 0;
        result.data = data.stream().map(VALUE_CHECKER).collect(Collectors.toList());
        return result;
    }
}

