/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.schedule;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.xcache.server.ServerContext;
import kd.bos.xcache.server.cmd.model.ResetMemoryCommand;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.schedule.PeriodFixedScheduleTask;
import kd.bos.xcache.server.schedule.TimerMetrics;
import kd.bos.xcache.server.util.Sizes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapMemoryCheckerTask
extends PeriodFixedScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(HeapMemoryCheckerTask.class);
    private static final int HIGH_THRESHOLD_PERCENT = 90;
    private static final int LOW_THRESHOLD_PERCENT = 80;
    public final long maxHeapMemory;
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();

    public HeapMemoryCheckerTask(ServerContext serverContext, ScheduledExecutorService service, TimerMetrics metrics) {
        super(serverContext, service, metrics, TimeUnit.SECONDS, 1L);
        this.maxHeapMemory = this.memoryMXBean.getHeapMemoryUsage().getMax();
    }

    @Override
    public void run() {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        long usedHeapMemory = heapMemoryUsage.getUsed();
        if (!this.isReachThreshold(usedHeapMemory, 90)) {
            this.schedule();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Max heap memory : %s, used: %s.", Sizes.format(this.maxHeapMemory), Sizes.format(usedHeapMemory)));
            }
            return;
        }
        if (!this.isDataMemoryReachThreshold(90)) {
            this.schedule();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Max heap memory : %s, used: %s. But data used less so skip.", Sizes.format(this.maxHeapMemory), Sizes.format(usedHeapMemory)));
            }
            return;
        }
        int resetPercent = 80;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Max heap memory : %s, used %s, data(allocator) used %s, try to decrease to %s.", Sizes.format(this.maxHeapMemory), Sizes.format(usedHeapMemory), Sizes.format(this.serverContext.getMemoryStats().used()), Sizes.format(Sizes.percent(usedHeapMemory, resetPercent))));
        }
        this.serverContext.getCommandInvokers().newLongInvoker(new ResetMemoryCommand(resetPercent)).onError(this.defaultErrorHandler).invoke(value -> {
            this.schedule();
            this.metrics.incrementEvictionCacheCount();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Reset %s caches.", Sizes.format(value)));
            }
        });
    }

    private boolean isDataMemoryReachThreshold(int threshold) {
        return this.serverContext.getMemoryStats().used() >= Sizes.percent(this.serverContext.getMemoryStats().max(), threshold);
    }

    private boolean isReachThreshold(long usedHeapMemory, int threshold) {
        return usedHeapMemory >= Sizes.percent(this.maxHeapMemory - ServerPlatform.overheadMemory(), threshold);
    }
}

