/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.schedule;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import kd.bos.xcache.server.metric.DefaultGaugeSet;

public class TimerMetrics
extends DefaultGaugeSet {
    private final LongAdder cleanExpireCache = new LongAdder();
    private final LongAdder evictionCache = new LongAdder();
    private final AtomicLong lastEviction = new AtomicLong();

    public TimerMetrics() {
        super("timer");
        this.gauges.put("timer_eviction_cache", this.evictionCache::sum);
        this.gauges.put("timer_clear_expire_cache", this.cleanExpireCache::sum);
        this.gauges.put("timer_eviction_cache_last_millis", this.lastEviction::get);
    }

    public void incrementEvictionCacheCount() {
        this.evictionCache.increment();
        this.lastEviction.set(System.currentTimeMillis());
    }

    public void incrementClearExpireCacheCount(long c) {
        this.cleanExpireCache.add(c);
    }
}

