/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.slowlog;

import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.xcache.server.protocol.Value;

public class SlowLog {
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private final long id;
    private final long unixTimeStamp;
    private final long cost;
    private final List<Value> args;
    private final Value hostAndPort;
    private static final Value clientName = Value.newBytes("".getBytes(StandardCharsets.UTF_8));

    public static SlowLog create(long cost, List<Value> args, Value hostAndPort) {
        return new SlowLog(idGenerator.incrementAndGet(), System.currentTimeMillis() / 1000L, cost, args, hostAndPort);
    }

    public SlowLog(long id, long unixTimeStamp, long cost, List<Value> args, Value hostAndPort) {
        this.id = id;
        this.unixTimeStamp = unixTimeStamp;
        this.cost = cost;
        this.args = args;
        this.hostAndPort = hostAndPort;
    }

    public Value toValue() {
        LinkedList<Value> log = new LinkedList<Value>();
        log.add(Value.newLong(this.id));
        log.add(Value.newLong(this.unixTimeStamp));
        log.add(Value.newLong(this.cost));
        log.add(Value.newList(this.args));
        log.add(this.hostAndPort);
        log.add(clientName);
        return Value.newList(log);
    }
}

