/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.slowlog;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.xcache.server.cmd.model.Command;
import kd.bos.xcache.server.common.RingBuffer;
import kd.bos.xcache.server.config.ServerPlatform;
import kd.bos.xcache.server.protocol.Value;
import kd.bos.xcache.server.slowlog.SlowLog;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.util.ByteBufUtil;

public class SlowLogManger {
    private static final int SLOWLOG_ENTRY_MAX_ARGC = 32;
    private static final int SLOWLOG_ENTRY_MAX_STRING = 128;
    private static final int size = ServerPlatform.slowlogMaxLen();
    private static final RingBuffer<SlowLog> ringBuffer = new RingBuffer(size);

    private SlowLogManger() {
    }

    public static boolean isEnable() {
        return ServerPlatform.slowlogLogSlowerThanMicroseconds() >= 0L;
    }

    public static boolean isSlowLog(long costMirco) {
        long logSlower = ServerPlatform.slowlogLogSlowerThanMicroseconds();
        return logSlower > 0L && costMirco > logSlower || logSlower == 0L;
    }

    public static SlowLog addSlowLog(long costMirco, Command command, String host, int port) {
        List<Value> args = SlowLogManger.toValueArgs(command);
        Value hostAndPort = Value.newBytes(String.format("%s:%s", host, port).getBytes(StandardCharsets.UTF_8));
        SlowLog result = SlowLog.create(costMirco, args, hostAndPort);
        ringBuffer.add(result);
        return result;
    }

    private static List<Value> toValueArgs(Command command) {
        LinkedList<Value> args = new LinkedList<Value>();
        args.add(Value.newBytes(command.type().mainCommand()));
        if (command.type().subCommand() != null) {
            args.add(Value.newBytes(command.type().subCommand()));
        }
        args.addAll(SlowLogManger.toValueArgs(command.args()));
        return args;
    }

    private static List<Value> toValueArgs(List<Object> args) {
        int more = args.size() - 32;
        int size = Math.min(args.size(), 32);
        ArrayList<Value> result = new ArrayList<Value>(more > 0 ? size + 1 : size);
        for (int i = 0; i < size; ++i) {
            result.add(SlowLogManger.toValue(args.get(i)));
        }
        if (more > 0) {
            result.add(Value.newBytes(String.format("... (%s more arguments)", more)));
        }
        return result;
    }

    private static Value toValue(Object arg) {
        String s;
        BufferString bs;
        int totalLen;
        String argString = arg instanceof BufferString ? ((totalLen = (bs = (BufferString)arg).length()) <= 128 ? SlowLogManger.subString(bs, bs.length()) : String.format("%s... (%s more bytes)", SlowLogManger.subString(bs, 128), totalLen - 128)) : ((s = String.valueOf(arg)).length() <= 128 ? s : String.format("%s... (%s more bytes)", s.substring(0, 128), s.length() - 128));
        return Value.newBytes(argString);
    }

    private static String subString(BufferString bs, int count) {
        return ByteBufUtil.subString(bs.buffer(), count);
    }

    public static List<SlowLog> getAll() {
        return ringBuffer.get(size);
    }

    public static int size() {
        return ringBuffer.size();
    }

    public static List<SlowLog> get(int count) {
        return count < 0 ? ringBuffer.get(size) : ringBuffer.get(count);
    }

    public static void reset() {
        ringBuffer.clean();
    }
}

