/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.basic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import kd.bos.xcache.server.common.ReferenceCounted;
import kd.bos.xcache.server.store.basic.Computable;
import kd.bos.xcache.server.util.ByteBufUtil;
import kd.bos.xcache.server.util.MemoryCalculator;

public final class BufferString
implements Computable,
ReferenceCounted {
    private static final int OBJECT_MEMORY = MemoryCalculator.calculate(BufferString.class);
    private final ByteBuf value;
    private int hash;

    public static BufferString wrap(byte[] bytes) {
        return BufferString.wrap(Unpooled.wrappedBuffer((byte[])bytes));
    }

    public static BufferString create(String string) {
        return BufferString.wrap(string.getBytes());
    }

    public static BufferString wrap(ByteBuf value) {
        return new BufferString(value);
    }

    private BufferString(ByteBuf value) {
        this.value = value;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ByteBufUtil.hashCode(this.value);
        }
        return this.hash;
    }

    public int length() {
        return this.value.readableBytes();
    }

    public ByteBuf buffer() {
        return this.value;
    }

    @Override
    public int memSize() {
        return OBJECT_MEMORY + this.value.capacity();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (!(o instanceof BufferString)) {
            return false;
        }
        return ByteBufUtil.equals(this.value, ((BufferString)o).value);
    }

    @Override
    public void retain() {
        this.value.retain();
    }

    @Override
    public void release() {
        ByteBufUtil.release(this.value);
    }
}

