/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.data;

import java.util.Optional;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.CacheObject;
import kd.bos.xcache.server.store.data.hash.HashCache;
import kd.bos.xcache.server.store.data.hash.HashDataBuilder;
import kd.bos.xcache.server.store.data.list.ListCache;
import kd.bos.xcache.server.store.data.list.ListDataBuilder;
import kd.bos.xcache.server.store.data.set.SetCache;
import kd.bos.xcache.server.store.data.set.SetDataBuilder;
import kd.bos.xcache.server.store.data.string.NumberCache;
import kd.bos.xcache.server.store.data.string.StringCache;
import kd.bos.xcache.server.util.Longs;

public class DataFactory {
    private DataFactory() {
    }

    public static CacheObject newStringCache(BufferString bufferString) {
        Optional<Long> number = Longs.parseLong(bufferString.buffer());
        return number.isPresent() ? new NumberCache(number.get()) : StringCache.of(bufferString);
    }

    public static HashCache newHashCache() {
        return new HashCache(HashDataBuilder.DEFAULT.build());
    }

    public static SetCache newSetCache() {
        return new SetCache(SetDataBuilder.DEFAULT.build());
    }

    public static ListCache newListCache() {
        return new ListCache(ListDataBuilder.DEFAULT.build());
    }

    public static NumberCache newNumberCache(Long number) {
        return new NumberCache(number);
    }
}

