/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.data.hash;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kd.bos.xcache.server.cmd.model.param.FieldAndValue;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.Key;
import kd.bos.xcache.server.store.data.hash.HashData;
import kd.bos.xcache.server.util.MemoryCalculator;

public class HashDataImpl
implements HashData {
    private static final int OBJECT_MEMORY = MemoryCalculator.calculate(HashDataImpl.class);
    private Map<Key, BufferString> delegate = new HashMap<Key, BufferString>();
    private static AtomicIntegerFieldUpdater<HashDataImpl> memoryUpdater = AtomicIntegerFieldUpdater.newUpdater(HashDataImpl.class, "memory");
    protected volatile int memory = OBJECT_MEMORY;

    HashDataImpl() {
    }

    @Override
    public BufferString get(Key field) {
        return this.delegate.get(field);
    }

    @Override
    public boolean exists(Key field) {
        return this.delegate.containsKey(field);
    }

    @Override
    public long size() {
        return this.delegate.size();
    }

    @Override
    public boolean put(Key field, BufferString value) {
        return this.doPut(field, value);
    }

    private boolean doPut(Key field, BufferString value) {
        BufferString previous = this.delegate.put(field, value);
        this.increaseMemory(field.memSize() + value.memSize());
        if (null != previous) {
            this.decreaseMemory(field.memSize() + previous.memSize());
            previous.release();
        }
        return null == previous;
    }

    private void increaseMemory(int value) {
        memoryUpdater.addAndGet(this, value);
    }

    private void decreaseMemory(int value) {
        memoryUpdater.addAndGet(this, -value);
    }

    @Override
    public long put(List<FieldAndValue> values) {
        long ret = 0L;
        for (FieldAndValue each : values) {
            ret += this.doPut(each.getField(), each.getValue()) ? 1L : 0L;
        }
        return ret;
    }

    @Override
    public List<BufferString> get(List<Key> fields) {
        ArrayList<BufferString> result = new ArrayList<BufferString>(fields.size());
        for (Key field : fields) {
            BufferString v = this.delegate.get(field);
            result.add(v);
        }
        return result;
    }

    @Override
    public Set<Key> fields() {
        HashSet<Key> result = new HashSet<Key>();
        result.addAll(this.delegate.keySet());
        return result;
    }

    @Override
    public long remove(List<Key> fields) {
        long result = 0L;
        for (Key each : fields) {
            result += this.doRemove(each) != null ? 1L : 0L;
        }
        return result;
    }

    private BufferString doRemove(Key field) {
        BufferString previous = this.delegate.remove(field);
        if (null != previous) {
            this.decreaseMemory(field.memSize() + previous.memSize());
            previous.release();
        }
        return previous;
    }

    @Override
    public int memSize() {
        return this.memory;
    }

    @Override
    public void release() {
        HashSet<Key> keys = new HashSet<Key>(this.delegate.keySet());
        for (Key field : keys) {
            this.doRemove(field);
        }
    }
}

