/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.data.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.list.ListData;
import kd.bos.xcache.server.util.MemoryCalculator;

public class ListDataImpl
implements ListData {
    private static final int OBJECT_MEMORY = MemoryCalculator.calculate(ListDataImpl.class);
    public static final int ARRAY_SIZE_THRESHOLD = 64;
    private List<BufferString> delegate = new LinkedList<BufferString>();
    private static AtomicIntegerFieldUpdater<ListDataImpl> memoryUpdater = AtomicIntegerFieldUpdater.newUpdater(ListDataImpl.class, "memory");
    protected volatile int memory = OBJECT_MEMORY;

    ListDataImpl() {
    }

    @Override
    public long size() {
        return this.delegate.size();
    }

    @Override
    public BufferString get(long index) {
        int size = this.delegate.size();
        long calculatedIndex = ListDataImpl.calculateIndex(index, size);
        if (calculatedIndex < 0L || calculatedIndex >= (long)size) {
            return null;
        }
        return this.delegate.get((int)calculatedIndex);
    }

    private static long calculateIndex(long index, long size) {
        return index >= 0L ? index : index + size;
    }

    @Override
    public void set(long index, BufferString value) throws IndexOutOfBoundsException {
        int size = this.delegate.size();
        long calculatedIndex = ListDataImpl.calculateIndex(index, size);
        if (calculatedIndex < 0L || calculatedIndex >= (long)size) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index, size));
        }
        BufferString oldValue = this.delegate.set((int)calculatedIndex, value);
        this.release(oldValue);
        this.increaseMemory(value.memSize());
    }

    private String outOfBoundsMsg(long index, long size) {
        return String.format("index: %s, size: %s", index, size);
    }

    @Override
    public void addLast(List<BufferString> values) {
        this.delegate.addAll(values);
        int increasedMemory = values.stream().mapToInt(BufferString::memSize).sum();
        this.increaseMemory(increasedMemory);
    }

    @Override
    public boolean insertAfter(BufferString pivot, BufferString value) {
        return this.insert(pivot, value, true);
    }

    @Override
    public boolean insertBefore(BufferString pivot, BufferString value) {
        return this.insert(pivot, value, false);
    }

    @Override
    public List<BufferString> range(long start, long stop) {
        int size = this.delegate.size();
        start = ListDataImpl.calculateIndex(start, size);
        stop = ListDataImpl.calculateIndex(stop, size);
        start = start < 0L ? 0L : start;
        long l = stop = stop > (long)(size - 1) ? (long)(size - 1) : stop;
        if (start > stop) {
            return Collections.emptyList();
        }
        long count = stop - start + 1L;
        LinkedList<BufferString> result = count > 64L ? new LinkedList() : new ArrayList((int)count);
        ListIterator<BufferString> iterator = this.delegate.listIterator((int)start);
        while (count-- > 0L) {
            result.add(iterator.next());
        }
        return result;
    }

    @Override
    public int remove(BufferString value) {
        return this.remove(this.delegate.listIterator(), value, this.delegate.size());
    }

    @Override
    public int removeFromFirst(BufferString value, long count) {
        return this.remove(this.delegate.listIterator(), value, count);
    }

    @Override
    public int removeFromLast(BufferString value, long count) {
        return this.remove(ListDataImpl.reverse(this.delegate.listIterator(this.delegate.size())), value, count);
    }

    @Override
    public int memSize() {
        return this.memory;
    }

    @Override
    public void release() {
        ListIterator<BufferString> iterator = this.delegate.listIterator();
        while (iterator.hasNext()) {
            BufferString value = (BufferString)iterator.next();
            iterator.remove();
            this.release(value);
        }
    }

    private boolean insert(BufferString pivot, BufferString value, boolean after) {
        ListIterator<BufferString> iterator = this.delegate.listIterator();
        boolean found = false;
        while (iterator.hasNext()) {
            BufferString each = iterator.next();
            if (!each.equals(pivot)) continue;
            if (after) {
                iterator.add(value);
            } else {
                this.delegate.add(iterator.previousIndex(), value);
            }
            this.increaseMemory(value.memSize());
            found = true;
            break;
        }
        pivot.release();
        return found;
    }

    private static <E> Iterator<E> reverse(ListIterator<E> iterator) {
        return new DescendingIterator<E>(iterator);
    }

    private int remove(Iterator<BufferString> iterator, BufferString value, long count) {
        int removedCount = 0;
        while ((long)removedCount < count && iterator.hasNext()) {
            BufferString each = iterator.next();
            if (!each.equals(value)) continue;
            iterator.remove();
            ++removedCount;
            this.release(each);
        }
        value.release();
        return removedCount;
    }

    private void increaseMemory(int value) {
        memoryUpdater.addAndGet(this, value);
    }

    private void decreaseMemory(int value) {
        memoryUpdater.addAndGet(this, -value);
    }

    private void release(BufferString value) {
        this.decreaseMemory(value.memSize());
        value.release();
    }

    private static class DescendingIterator<E>
    implements Iterator<E> {
        private final ListIterator<E> itr;

        public DescendingIterator(ListIterator<E> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

