/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.data.set;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kd.bos.xcache.server.store.basic.BufferString;
import kd.bos.xcache.server.store.data.set.SetData;
import kd.bos.xcache.server.util.MemoryCalculator;

public class SetDataImpl
implements SetData {
    private static final int OBJECT_MEMORY = MemoryCalculator.calculate(SetDataImpl.class);
    private Map<BufferString, BufferString> delegate = new HashMap<BufferString, BufferString>();
    private static AtomicIntegerFieldUpdater<SetDataImpl> memoryUpdater = AtomicIntegerFieldUpdater.newUpdater(SetDataImpl.class, "memory");
    protected volatile int memory = OBJECT_MEMORY;

    SetDataImpl() {
    }

    @Override
    public long add(List<BufferString> values) {
        long addCount = 0L;
        for (BufferString value : values) {
            if (this.delegate.containsKey(value)) {
                value.release();
                continue;
            }
            this.delegate.put(value, value);
            this.increaseMemory(value.memSize());
            ++addCount;
        }
        return addCount;
    }

    @Override
    public long size() {
        return this.delegate.size();
    }

    @Override
    public long remove(List<BufferString> values) {
        long removedCount = 0L;
        for (BufferString value : values) {
            if (!this.doRemove(value)) continue;
            ++removedCount;
        }
        return removedCount;
    }

    @Override
    public Set<BufferString> values() {
        return new HashSet<BufferString>(this.delegate.keySet());
    }

    private void increaseMemory(int value) {
        memoryUpdater.addAndGet(this, value);
    }

    private void decreaseMemory(int value) {
        memoryUpdater.addAndGet(this, -value);
    }

    private boolean doRemove(BufferString key) {
        BufferString value = this.delegate.remove(key);
        if (value == null) {
            return false;
        }
        this.decreaseMemory(value.memSize());
        value.release();
        return true;
    }

    @Override
    public int memSize() {
        return this.memory;
    }

    @Override
    public void release() {
        HashSet<BufferString> values = new HashSet<BufferString>(this.delegate.keySet());
        for (BufferString value : values) {
            this.doRemove(value);
        }
    }
}

