/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.store.index;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.xcache.server.exception.UnExceptedException;
import org.apache.commons.lang3.tuple.Pair;

public class ScanAbleMap<K, V>
extends HashMap<K, V> {
    public static final int INT_BITS_SIZE = 32;
    public static final int INT_MASK = -1;
    private static final Field HASH_MAP_TABLE_FIELD;
    private static final Field HASH_MAP_NODE_NEXT_FIELD;

    public <R> Pair<Integer, List<Pair<K, R>>> scan(int cursor, int count, Predicate<V> valueFilter, Function<V, R> mapper) {
        try {
            Object[] table = (Object[])HASH_MAP_TABLE_FIELD.get(this);
            if (table == null || table.length == 0 || count <= 0 || cursor < 0) {
                return Pair.of((Object)0, (Object)Collections.EMPTY_LIST);
            }
            long maxLoop = count * 10;
            int bucketSize = table.length;
            cursor &= bucketSize - 1;
            LinkedList<Pair> result = new LinkedList<Pair>();
            do {
                Object node = table[cursor];
                while (node != null) {
                    Map.Entry entry = (Map.Entry)node;
                    if (valueFilter.test(entry.getValue())) {
                        result.add(Pair.of(entry.getKey(), mapper.apply(entry.getValue())));
                        --count;
                    }
                    node = HASH_MAP_NODE_NEXT_FIELD.get(node);
                    --maxLoop;
                }
                cursor = this.nextBucket(bucketSize, cursor);
            } while (count > 0 && cursor != 0 && --maxLoop > 0L);
            return Pair.of((Object)cursor, result);
        }
        catch (ReflectiveOperationException e) {
            throw new UnExceptedException(e, String.format("Error occurred when access field of hashmap: %s", e.getMessage()));
        }
    }

    private int nextBucket(int bucketSize, int cursor) {
        cursor |= ~(bucketSize - 1);
        cursor = ScanAbleMap.rev(cursor);
        ++cursor;
        cursor = ScanAbleMap.rev(cursor);
        return cursor;
    }

    private static int rev(int v) {
        int s = 32;
        int mask = -1;
        while ((s >>= 1) > 0) {
            mask ^= mask << s;
            v = v >> s & mask | v << s & ~mask;
        }
        return v;
    }

    static {
        try {
            HASH_MAP_TABLE_FIELD = HashMap.class.getDeclaredField("table");
            HASH_MAP_TABLE_FIELD.setAccessible(true);
            Class<?> nodeClass = Class.forName("java.util.HashMap$Node");
            HASH_MAP_NODE_NEXT_FIELD = nodeClass.getDeclaredField("next");
            HASH_MAP_NODE_NEXT_FIELD.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new UnExceptedException(e, String.format("Error occurred when get field of hashmap: %s", e.getMessage()));
        }
    }
}

