/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xcache.server.util;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ByteBufUtil {
    static final int HASHCODE_BIG_SIZE_THRESHOLD = 1024;
    static final int HASHCODE_TRUNK_SIZE = 128;
    static final int EQUALS_TRUNK_SIZE = 1024;

    private ByteBufUtil() {
    }

    public static void release(ByteBuf byteBuf) {
        ReferenceCountUtil.release((Object)byteBuf);
    }

    public static String subString(ByteBuf byteBuf, int count) {
        if (byteBuf == null) {
            return null;
        }
        count = Math.min(count, byteBuf.readableBytes());
        byte[] data = new byte[count];
        byteBuf.getBytes(byteBuf.readerIndex(), data);
        return new String(data, StandardCharsets.UTF_8);
    }

    public static int hashCode(ByteBuf buffer) {
        int length = buffer.readableBytes();
        int index = buffer.readerIndex();
        if (length < 1024) {
            return ByteBufUtil.hashCodeForSmallBuf(buffer, index, new byte[length]);
        }
        byte[] bytes = new byte[128];
        int result = ByteBufUtil.hashCodeForSmallBuf(buffer, index, bytes) ^ ByteBufUtil.hashCodeForSmallBuf(buffer, length / 2, bytes) ^ ByteBufUtil.hashCodeForSmallBuf(buffer, length - 128, bytes);
        return result == 0 ? 1 : result;
    }

    private static int hashCodeForSmallBuf(ByteBuf byteBuf, int index, byte[] bytes) {
        byteBuf.getBytes(index, bytes);
        Arrays.equals(bytes, bytes);
        return Arrays.hashCode(bytes);
    }

    public static boolean equals(ByteBuf a, ByteBuf b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return b == null && a == null;
        }
        int length = a.readableBytes();
        if (length != b.readableBytes()) {
            return false;
        }
        int indexA = a.readerIndex();
        int indexB = b.readerIndex();
        if (length < 1024) {
            return ByteBufUtil.equalsForSmallBuf(a, b, indexA, new byte[length], indexB, new byte[length], length);
        }
        byte[] bytesA = new byte[1024];
        byte[] bytesB = new byte[1024];
        int left = length;
        do {
            a.getBytes(indexA, bytesA);
            indexA += 1024;
            b.getBytes(indexB, bytesB);
            indexB += 1024;
            left -= 1024;
            if (ByteBufUtil.bytesEquals(bytesA, bytesB, 1024)) continue;
            return false;
        } while (left >= 1024);
        if (left <= 0) {
            return true;
        }
        return ByteBufUtil.equalsForSmallBuf(a, b, indexA, bytesA, indexB, bytesB, left);
    }

    private static boolean equalsForSmallBuf(ByteBuf a, ByteBuf b, int indexA, byte[] bytesA, int indexB, byte[] bytesB, int length) {
        a.getBytes(indexA, bytesA, 0, length);
        b.getBytes(indexB, bytesB, 0, length);
        return ByteBufUtil.bytesEquals(bytesA, bytesB, length);
    }

    private static boolean bytesEquals(byte[] a, byte[] b, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

