/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.serialization;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.common.serialization.ObjectInput;
import kd.bos.mservice.common.serialization.ObjectOutput;
import kd.bos.mservice.common.serialization.Serialization;
import kd.bos.mservice.common.serialization.SerializationFactory;
import kd.bos.mservice.sdk.extension.SdkExtensionFactory;
import kd.bos.mservice.serialization.KServiceSerialization;
import kd.bos.mservice.serialization.SerializationException;

public class BinarySerializationAdapter
implements KServiceSerialization {
    private static Map<String, BinarySerializationAdapter> codeceres = new ConcurrentHashMap<String, BinarySerializationAdapter>(2);
    private static SdkExtensionFactory<Serialization> lookupFactory = SdkExtensionFactory.getExtensionFacotry(Serialization.class);
    private Serialization serilaizer;

    protected static BinarySerializationAdapter getSerializer(String type) {
        return codeceres.computeIfAbsent(type, k -> {
            Serialization s = SerializationFactory.get(type);
            if (s == null) {
                if (lookupFactory.existsExtension(type)) {
                    s = (Serialization)lookupFactory.getExtension(type);
                } else {
                    return null;
                }
            }
            return new BinarySerializationAdapter(s);
        });
    }

    private BinarySerializationAdapter(Serialization serilaizer) {
        this.serilaizer = serilaizer;
    }

    @Override
    public void serialize(Object obj, OutputStream out) {
        try {
            ObjectOutput output = this.serilaizer.serialize(out);
            output.writeObject(obj);
            output.flushBuffer();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            if (e.getCause() instanceof EOFException) {
                return;
            }
            throw new SerializationException("serialize error", e);
        }
    }

    @Override
    public <T> T deserialize(InputStream in, Class<T> type) {
        return this._deserialize(in);
    }

    private <T> T _deserialize(InputStream in) {
        try {
            ObjectInput input = this.serilaizer.deserialize(in);
            Object obj = input.readObject();
            return (T)obj;
        }
        catch (Exception e) {
            throw new SerializationException("deserialize error", e);
        }
    }

    @Override
    public <T> T deserializeWithParameterizedType(InputStream in, ParameterizedType type) {
        return this._deserialize(in);
    }

    protected static KServiceSerialization getDefaultBinarySerializer() {
        return codeceres.computeIfAbsent("getDefaultBinaryCoder", k -> new BinarySerializationAdapter(SerializationFactory.get()));
    }
}

