/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.serialization;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.sdk.extension.SdkExtensionFactory;
import kd.bos.mservice.serialization.BinarySerializationAdapter;
import kd.bos.mservice.serialization.KServiceSerialization;

public class KServiceSerializationFactory {
    private static Map<String, KServiceSerialization> codeceres = new ConcurrentHashMap<String, KServiceSerialization>(2);
    private static SdkExtensionFactory<KServiceSerialization> lookupFactory = SdkExtensionFactory.getExtensionFacotry(KServiceSerialization.class);

    public static KServiceSerialization getSerializer(String type) {
        return codeceres.computeIfAbsent(type, k -> {
            BinarySerializationAdapter adapter = BinarySerializationAdapter.getSerializer(type);
            if (adapter != null) {
                return adapter;
            }
            return (KServiceSerialization)lookupFactory.getExtension(type);
        });
    }

    public static KServiceSerialization getDefaultBinarySerializer() {
        return BinarySerializationAdapter.getDefaultBinarySerializer();
    }

    public static boolean isBinarySerialization(String type) {
        return BinarySerializationAdapter.getSerializer(type) != null;
    }
}

