/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.serialization;

import java.io.PrintWriter;
import java.io.StringWriter;
import kd.bos.mservice.serialization.SerializationErrorCode;

public class SerializationException
extends RuntimeException {
    private static final long serialVersionUID = -6277095208290718410L;
    private static final Object[] empty_args = new Object[0];
    private static final SerializationErrorCode empty_error_code = new SerializationErrorCode("", "");
    protected SerializationErrorCode errorCode;
    protected Object[] args;

    public SerializationException(SerializationErrorCode errorCode, Object ... args) {
        super(errorCode.getMessage());
        this.errorCode = errorCode;
        this.args = args;
    }

    public SerializationException(String msg, Throwable e) {
        super(msg, e);
    }

    public SerializationException(String msg) {
        super(msg);
    }

    public SerializationErrorCode getSerializationErrorCode() {
        return this.errorCode;
    }

    public Object[] getArgs() {
        return this.args == null ? empty_args : this.args;
    }

    public String getStackTraceMessage() {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        this.printStackTrace(writer);
        writer.flush();
        return sw.toString();
    }

    @Override
    public String getMessage() {
        if (this.errorCode == null || this.errorCode == empty_error_code) {
            return super.getMessage();
        }
        return this.format(this.errorCode.getMessage());
    }

    private String format(String msg) {
        if (this.args == null || this.args.length == 0) {
            return msg;
        }
        try {
            return String.format(msg, this.args);
        }
        catch (Exception ignored) {
            return msg;
        }
    }
}

