/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.api;

import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.exception.PoolErrorCode;
import kd.bos.unifiedthreadpool.exception.ThreadPoolCreateException;
import kd.bos.unifiedthreadpool.exception.UnifiedThreadPoolException;
import kd.bos.unifiedthreadpool.helper.ThreadPoolManager;
import kd.bos.unifiedthreadpool.impl.ThreadPoolExecutor;
import kd.bos.unifiedthreadpool.impl.ThreadPoolExecutorWrap;
import kd.bos.unifiedthreadpool.impl.ThreadPoolStrategyImpl;
import kd.bos.unifiedthreadpool.utils.AssertWithLog;
import kd.bos.unifiedthreadpool.utils.ConfigReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolFactory {
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolFactory.class);

    public static ThreadExecutorService create(String region, String threadPoolName, ThreadPoolStrategy threadPoolStrategy) throws UnifiedThreadPoolException {
        if (ConfigReader.isWebNode()) {
            logger.warn("pthreadpools,The web node not need to create PriorityThreadPool.");
            return null;
        }
        AssertWithLog.isNotEmptyWithException(region, "region can't be empty!", new Object[0]);
        AssertWithLog.isNotEmptyWithException(threadPoolName, "threadPoolName can't be empty!", new Object[0]);
        AssertWithLog.isNullWithException(threadPoolStrategy, "threadPoolStrategy can't be null!", new Object[0]);
        boolean registered = ConfigReader.validate(region, threadPoolName);
        if (!registered) {
            String msg = String.format("Uthreadpools,The region [%s] of [%s] is unregistered!", region, threadPoolName);
            logger.error(msg, (Object)"pthreadpools");
            throw new ThreadPoolCreateException(PoolErrorCode.POOL_UNREGISTERED, msg);
        }
        if (ThreadPoolManager.exist(region, threadPoolName)) {
            return ThreadPoolManager.getExecutorService(region, threadPoolName);
        }
        ThreadPoolStrategyImpl sta = (ThreadPoolStrategyImpl)threadPoolStrategy;
        sta.setRegion(region);
        sta.setPoolName(threadPoolName);
        sta.validate();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(region, threadPoolName, sta);
        executor.setDescription(ConfigReader.getRegionDes(region));
        ThreadPoolExecutorWrap wrap = ThreadPoolExecutorWrap.wrap(executor);
        ThreadPoolManager.register(region, threadPoolName, wrap);
        return wrap;
    }
}

