/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.unifiedthreadpool.exception.PoolErrorCode;
import kd.bos.unifiedthreadpool.exception.ThreadPoolStrategyException;
import kd.bos.unifiedthreadpool.helper.ThreadPoolManager;
import kd.bos.unifiedthreadpool.helper.vo.TaskTypeInfo;
import kd.bos.unifiedthreadpool.helper.vo.ThreadPoolInfo;
import kd.bos.unifiedthreadpool.impl.ThreadPoolExecutor;
import kd.bos.unifiedthreadpool.impl.ThreadPoolStrategyImpl;
import kd.bos.unifiedthreadpool.tasktype.FullTaskType;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.ThreadLimitedModel;

public class ThreadPoolHelper {
    public static ThreadPoolInfo getThreadPoolInfo(String cloudId, String poolName) {
        ThreadPoolExecutor executor = ThreadPoolManager.getExecutor(cloudId, poolName);
        return ThreadPoolHelper.newForInfo(executor);
    }

    public static boolean removeThreadPool(String region, String poolName) {
        return ThreadPoolManager.removeThreadPool(region, poolName);
    }

    public static List<ThreadPoolInfo> getAllThreadPoolInfo() {
        List<ThreadPoolExecutor> executors = ThreadPoolManager.getAllExecutor();
        ArrayList<ThreadPoolInfo> infoList = new ArrayList<ThreadPoolInfo>(executors.size());
        for (ThreadPoolExecutor executor : executors) {
            infoList.add(ThreadPoolHelper.newForInfo(executor));
        }
        return infoList;
    }

    public static void setThreadPoolConfig(ThreadPoolInfo poolConfig) {
        String poolName;
        String cloudId = poolConfig.getCloudId();
        if (!ThreadPoolManager.exist(cloudId, poolName = poolConfig.getPoolName())) {
            throw new ThreadPoolStrategyException(PoolErrorCode.POOL_NOT_CREATED, "Region:[" + cloudId + "] poolName:[" + poolName + "] The thread pool has not been created!");
        }
        ThreadPoolStrategyImpl strategy = ThreadPoolStrategyImpl.build().setMinThreadNum(poolConfig.getMinThreadNum()).setMaxThreadNum(poolConfig.getMaxThreadNum()).setOverflowThreadNum(poolConfig.getOverflowThreadNum()).setThreadIdeMinutes(poolConfig.getThreadIdeTime());
        List<TaskTypeInfo> typeInfoList = poolConfig.getTaskTypeList();
        if (typeInfoList == null || typeInfoList.size() == 0) {
            throw new ThreadPoolStrategyException(PoolErrorCode.ILLEGAL_TASK_TYPE, " taskTypeList cannot be empty!");
        }
        ArrayList<FullTaskType> typeList = new ArrayList<FullTaskType>(typeInfoList.size());
        for (TaskTypeInfo typeInfo : typeInfoList) {
            ThreadLimitedModel limitType = ThreadLimitedModel.getTaskLimitEnum(typeInfo.getLimitType());
            boolean isRate = ThreadLimitedModel.RATE == limitType;
            String maxThreadLimit = typeInfo.getMaxThreadLimit();
            float rate = isRate ? Float.parseFloat(maxThreadLimit) : 0.0f;
            int maxNum = isRate ? 0 : Integer.parseInt(maxThreadLimit);
            FullTaskType type = FullTaskType.build().setName(typeInfo.getTaskName()).setPriority(Priority.getByLevel(typeInfo.getPriority())).setLimitType(limitType).setMaxThreadRate(rate).setMaxThreadNum(maxNum).setTaskQueueMaxSize(typeInfo.getTaskQueueMaxSize()).setImmutable(typeInfo.isImmutable()).setCanRun(typeInfo.isCanRun());
            typeList.add(type);
        }
        strategy.setFullTaskTypeList(typeList);
        strategy.validate();
        ThreadPoolManager.changeThreadPoolStrategy(cloudId, poolName, strategy);
    }

    private static ThreadPoolInfo newForInfo(ThreadPoolExecutor executor) {
        ThreadPoolInfo info = new ThreadPoolInfo();
        ThreadPoolStrategyImpl strategy = executor.getStrategy();
        info.setPoolName(executor.getPoolName());
        info.setCloudId(executor.getRegion());
        info.setCloudDes(executor.getDescription());
        int maxThreadNum = strategy.getMaxThreadNum();
        int currentThreadNum = executor.getPoolSize();
        int overflowThreadNum = currentThreadNum > maxThreadNum ? currentThreadNum - maxThreadNum : 0;
        int activeCount = executor.getActiveCount();
        long completedCount = executor.getCompletedTaskCount();
        int waitingCount = executor.getQueue().size();
        double load = (double)activeCount / (double)maxThreadNum;
        BigDecimal bg = BigDecimal.valueOf(load).setScale(2, RoundingMode.UP);
        load = bg.doubleValue();
        info.setMinThreadNum(strategy.getMinThreadNum());
        info.setMaxThreadNum(strategy.getMaxThreadNum());
        info.setCurrentThreadNum(currentThreadNum);
        info.setOverflowThreadNum(overflowThreadNum);
        info.setMaxOverflowThreadNum(strategy.getOverflowThreadNum());
        info.setActiveThreadNum(activeCount);
        info.setWaitingTaskCount(waitingCount);
        info.setExecutedTotalCount(completedCount);
        info.setRejectedTotalCount(executor.getRejectedTaskCount());
        info.setThreadIdeTime(strategy.getThreadIdeMinutes());
        info.setThreadLoad(load);
        Collection<FullTaskType> typeList = executor.getQueue().getAllTaskType();
        info.setTaskTypeNum(typeList.size());
        ArrayList<TaskTypeInfo> typeInfoList = new ArrayList<TaskTypeInfo>(typeList.size());
        for (FullTaskType type : typeList) {
            ThreadLimitedModel limitType = type.getLimitType();
            String maxThreadLimit = ThreadLimitedModel.RATE == limitType ? String.valueOf(type.getMaxThreadRate()) : String.valueOf(type.getMaxThreadNum());
            TaskTypeInfo tti = new TaskTypeInfo();
            tti.setTaskName(type.getName());
            tti.setLimitType(type.getLimitType().getType());
            tti.setMaxThreadLimit(maxThreadLimit);
            tti.setTaskQueueMaxSize(type.getTaskQueueMaxSize());
            tti.setPriority(type.getPriority().getLevel());
            tti.setRejectedTotalCount(type.getRejectedTotalCount());
            tti.setExecutedTotalCount(type.getExecutedTotalCount());
            tti.setActiveThreadCount(type.getActiveThreadCount());
            tti.setWaitingTaskCount(type.getQueueSize());
            tti.setExecuteAvgMilliTime(type.getExecuteAvgMilliTime());
            tti.setInQueueAvgMilliTime(type.getInQueueAvgMilliTime());
            tti.setImmutable(type.isImmutable());
            tti.setCanRun(type.isCanRun());
            typeInfoList.add(tti);
        }
        info.setTaskTypeList(typeInfoList);
        return info;
    }
}

