/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.impl.ThreadPoolExecutor;
import kd.bos.unifiedthreadpool.impl.ThreadPoolExecutorWrap;
import kd.bos.unifiedthreadpool.impl.ThreadPoolStrategyImpl;

public class ThreadPoolManager {
    private static final ConcurrentHashMap<String, ThreadExecutorService> THREAD_POOL_POOLS = new ConcurrentHashMap(3);

    public static void register(String region, String poolName, ThreadExecutorService threadPoolExecutor) {
        THREAD_POOL_POOLS.put(ThreadPoolManager.getKey(region, poolName), threadPoolExecutor);
    }

    public static ThreadPoolExecutor getExecutor(String region, String poolName) {
        ThreadPoolExecutorWrap wrap = (ThreadPoolExecutorWrap)THREAD_POOL_POOLS.get(ThreadPoolManager.getKey(region, poolName));
        return wrap.delegate();
    }

    public static ThreadExecutorService getExecutorService(String region, String poolName) {
        return THREAD_POOL_POOLS.get(ThreadPoolManager.getKey(region, poolName));
    }

    public static List<ThreadPoolExecutor> getAllExecutor() {
        ArrayList<ThreadPoolExecutor> executors = new ArrayList<ThreadPoolExecutor>(THREAD_POOL_POOLS.size());
        THREAD_POOL_POOLS.forEach((k, v) -> executors.add(((ThreadPoolExecutorWrap)v).delegate()));
        return executors;
    }

    public static boolean exist(String region, String poolName) {
        return THREAD_POOL_POOLS.containsKey(ThreadPoolManager.getKey(region, poolName));
    }

    public static boolean changeThreadPoolStrategy(String region, String poolName, ThreadPoolStrategyImpl strategy) {
        if (!ThreadPoolManager.exist(region, poolName)) {
            return false;
        }
        ThreadPoolExecutor executor = ThreadPoolManager.getExecutor(region, poolName);
        executor.setThreadPoolStrategy(strategy);
        return true;
    }

    public static boolean removeThreadPool(String region, String poolName) {
        ThreadExecutorService service = THREAD_POOL_POOLS.remove(ThreadPoolManager.getKey(region, poolName));
        return service == null;
    }

    private static String getKey(String region, String poolName) {
        return region + "_" + poolName;
    }
}

