/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.impl;

import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.thread.SetThreadName;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.unifiedthreadpool.api.PoolRejectedExecutionHandler;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.impl.ThreadPoolStrategyImpl;
import kd.bos.unifiedthreadpool.policy.DiscardPolicy;
import kd.bos.unifiedthreadpool.queue.MultiTaskBlockingQueue;
import kd.bos.unifiedthreadpool.tasktype.FullTaskType;
import kd.bos.unifiedthreadpool.tasktype.TaskType;
import kd.bos.unifiedthreadpool.thread.DefaultThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolExecutor
extends AbstractExecutorService
implements ThreadExecutorService {
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolExecutor.class);
    private final AtomicInteger ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(-536870912, 0));
    private static final int COUNT_BITS = 29;
    private static final int CAPACITY = 0x1FFFFFFF;
    private static final int RUNNING = -536870912;
    private static final int SHUTDOWN = 0;
    private static final int STOP = 0x20000000;
    private static final int TIDYING = 0x40000000;
    private static final int TERMINATED = 0x60000000;
    private final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);
    private Map<String, Long> startNanoTimeMap = new ConcurrentHashMap<String, Long>(8);
    private String poolName;
    private String region;
    private String description;
    private ThreadPoolStrategyImpl strategy;
    private final MultiTaskBlockingQueue workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet<Worker> workers = new HashSet();
    private final Condition termination = this.mainLock.newCondition();
    private int largestPoolSize;
    private long completedTaskCount;
    private AtomicLong rejectedTaskCount = new AtomicLong(0L);
    private volatile ThreadFactory threadFactory;
    private volatile PoolRejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final PoolRejectedExecutionHandler defaultHandler = new DiscardPolicy();
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private final AccessControlContext acc;
    private static final boolean ONLY_ONE = true;

    private static int runStateOf(int c) {
        return c & 0xE0000000;
    }

    private static int workerCountOf(int c) {
        return c & 0x1FFFFFFF;
    }

    private static int ctlOf(int rs, int wc) {
        return rs | wc;
    }

    private FullTaskType getTaskType(Runnable command) {
        String taskType = "";
        if (command instanceof TaskRunnable) {
            TaskRunnable runnable = (TaskRunnable)command;
            taskType = runnable.taskType;
        } else if (command instanceof FutureTaskWrap) {
            FutureTaskWrap future = (FutureTaskWrap)command;
            taskType = future.taskType;
        }
        FullTaskType type = this.workQueue.getTaskType(taskType);
        return type;
    }

    private static boolean runStateLessThan(int c, int s) {
        return c < s;
    }

    private static boolean runStateAtLeast(int c, int s) {
        return c >= s;
    }

    private static boolean isRunning(int c) {
        return c < 0;
    }

    private boolean compareAndIncrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect + 1);
    }

    private boolean compareAndDecrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect - 1);
    }

    private void decrementWorkerCount() {
        while (!this.compareAndDecrementWorkerCount(this.ctl.get())) {
        }
    }

    public void execute(Runnable command, String taskType, RequestContext context) {
        TaskRunnable runnable = new TaskRunnable(command, taskType);
        runnable.setContext(context);
        this.execute(runnable);
    }

    @Override
    public void execute(Runnable command, String registeredTaskTypeName, RequestContext context, OperationContext oc) {
        TaskRunnable runnable = new TaskRunnable(command, registeredTaskTypeName);
        runnable.setContext(context);
        runnable.setOc(oc);
        this.execute(command);
    }

    public void execute(Runnable command, String taskType) {
        TaskRunnable runnable = new TaskRunnable(command, taskType);
        this.execute(runnable);
    }

    public <T> Future<T> submit(Callable<T> task, String taskType, RequestContext context) {
        TaskCallable<T> callable = new TaskCallable<T>(task, taskType);
        callable.setContext(context);
        RunnableFuture<T> ftask = this.newTaskForFutureTask(callable, taskType);
        this.execute(ftask);
        return ftask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, String registeredTaskTypeName, RequestContext context, OperationContext oc) {
        TaskCallable<T> callable = new TaskCallable<T>(task, registeredTaskTypeName);
        callable.setContext(context);
        callable.setOc(oc);
        RunnableFuture<T> ftask = this.newTaskForFutureTask(callable, registeredTaskTypeName);
        this.execute(ftask);
        return ftask;
    }

    public <T> Future<T> submit(Callable<T> task, String registeredTaskTypeName) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<T> ftask = this.newTaskForFutureTask(new TaskCallable<T>(task, registeredTaskTypeName), registeredTaskTypeName);
        this.execute(ftask);
        return ftask;
    }

    public Future<?> submit(Runnable task, String taskType, RequestContext context) {
        TaskRunnable runnable = new TaskRunnable(task, taskType);
        runnable.setContext(context);
        RunnableFuture<Object> ftask = this.newTaskForFutureTask(runnable, null, taskType);
        this.execute(ftask);
        return ftask;
    }

    public Future<?> submit(Runnable task, String registeredTaskTypeName, RequestContext context, OperationContext oc) {
        TaskRunnable runnable = new TaskRunnable(task, registeredTaskTypeName);
        runnable.setContext(context);
        runnable.setOc(oc);
        RunnableFuture<Object> ftask = this.newTaskForFutureTask(runnable, null, registeredTaskTypeName);
        this.execute(ftask);
        return ftask;
    }

    public Future<?> submit(Runnable task, String taskType) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture<Object> ftask = this.newTaskForFutureTask(new TaskRunnable(task, taskType), null, taskType);
        this.execute(ftask);
        return ftask;
    }

    private <T> RunnableFuture<T> newTaskForFutureTask(Callable<T> callable, String taskType) {
        return new FutureTaskWrap<T>(callable, taskType);
    }

    private <T> RunnableFuture<T> newTaskForFutureTask(Runnable runnable, T value, String taskType) {
        return new FutureTaskWrap<T>(runnable, value, taskType);
    }

    private void advanceRunState(int targetState) {
        int c;
        while (!ThreadPoolExecutor.runStateAtLeast(c = this.ctl.get(), targetState) && !this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(targetState, ThreadPoolExecutor.workerCountOf(c)))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate() {
        int c;
        while (!(ThreadPoolExecutor.isRunning(c = this.ctl.get()) || ThreadPoolExecutor.runStateAtLeast(c, 0x40000000) || ThreadPoolExecutor.runStateOf(c) == 0 && !this.workQueue.isEmpty())) {
            if (ThreadPoolExecutor.workerCountOf(c) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (!this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(0x40000000, 0))) continue;
                try {
                    this.terminated();
                }
                finally {
                    this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                    this.termination.signalAll();
                }
                return;
            }
            finally {
                mainLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(shutdownPerm);
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                for (Worker w : this.workers) {
                    security.checkAccess(w.thread);
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                w.interruptIfStarted();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptIdleWorkers(boolean onlyOne) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                Thread t = w.thread;
                if (!t.isInterrupted() && w.tryLock()) {
                    try {
                        t.interrupt();
                    }
                    catch (SecurityException securityException) {
                    }
                    finally {
                        w.unlock();
                    }
                }
                if (!onlyOne) continue;
                break;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    final void reject(Runnable command) {
        FullTaskType fullTaskType = this.getTaskType(command);
        if (fullTaskType != null) {
            fullTaskType.incrementRejectedTotalCount();
            logger.warn("{} unifiedthreadpool task rejected: taskType={}, ThreadPool={} ", new Object[]{this.region, fullTaskType.getName(), this});
        }
        this.rejectedTaskCount.incrementAndGet();
        this.handler.rejectedExecution(command, this);
    }

    void onShutdown() {
    }

    final boolean isRunningOrShutdown(boolean shutdownOK) {
        int rs = ThreadPoolExecutor.runStateOf(this.ctl.get());
        return rs == -536870912 || rs == 0 && shutdownOK;
    }

    private List<Runnable> drainQueue() {
        MultiTaskBlockingQueue q = this.workQueue;
        ArrayList<Runnable> taskList = new ArrayList<Runnable>();
        q.drainTo(taskList);
        return taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable firstTask, boolean core) {
        boolean workerStarted;
        block15: {
            block6: while (true) {
                int c;
                int rs;
                if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) >= 0 && (rs != 0 || firstTask != null || this.workQueue.isEmpty())) {
                    return false;
                }
                do {
                    int wc;
                    if ((wc = ThreadPoolExecutor.workerCountOf(c)) >= 0x1FFFFFFF || wc >= (core ? this.corePoolSize : this.maximumPoolSize)) {
                        return false;
                    }
                    if (this.compareAndIncrementWorkerCount(c)) break block6;
                } while (ThreadPoolExecutor.runStateOf(c = this.ctl.get()) == rs);
            }
            workerStarted = false;
            boolean workerAdded = false;
            Worker w = null;
            try {
                w = new Worker(firstTask);
                Thread t = w.thread;
                if (t == null) break block15;
                ReentrantLock mainLock = this.mainLock;
                mainLock.lock();
                try {
                    int rs = ThreadPoolExecutor.runStateOf(this.ctl.get());
                    if (rs < 0 || rs == 0 && firstTask == null) {
                        if (t.isAlive()) {
                            throw new IllegalThreadStateException();
                        }
                        this.workers.add(w);
                        int s = this.workers.size();
                        if (s > this.largestPoolSize) {
                            this.largestPoolSize = s;
                        }
                        workerAdded = true;
                    }
                }
                finally {
                    mainLock.unlock();
                }
                if (workerAdded) {
                    t.start();
                    workerStarted = true;
                }
            }
            finally {
                if (!workerStarted) {
                    this.addWorkerFailed(w);
                }
            }
        }
        return workerStarted;
    }

    private void addWorkerFailed(Worker w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (w != null) {
                this.workers.remove(w);
            }
            this.decrementWorkerCount();
            this.tryTerminate();
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker w, boolean completedAbruptly) {
        if (completedAbruptly) {
            this.decrementWorkerCount();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        int c = this.ctl.get();
        if (ThreadPoolExecutor.runStateLessThan(c, 0x20000000)) {
            if (!completedAbruptly) {
                int min;
                int n = min = this.allowCoreThreadTimeOut ? 0 : this.corePoolSize;
                if (min == 0 && !this.workQueue.isEmpty()) {
                    min = 1;
                }
                if (ThreadPoolExecutor.workerCountOf(c) >= min) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private Runnable getTask() {
        boolean timedOut = false;
        while (true) {
            boolean timed;
            int c;
            int rs;
            if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) >= 0 && (rs >= 0x20000000 || this.workQueue.isEmpty())) {
                this.decrementWorkerCount();
                return null;
            }
            int wc = ThreadPoolExecutor.workerCountOf(c);
            boolean bl = timed = this.allowCoreThreadTimeOut || wc > this.corePoolSize;
            if ((wc > this.maximumPoolSize || timed && timedOut) && (wc > 1 || this.workQueue.isEmpty())) {
                if (!this.compareAndDecrementWorkerCount(c)) continue;
                return null;
            }
            try {
                Runnable r;
                Runnable runnable = r = timed ? this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : this.workQueue.take();
                if (r != null) {
                    return r;
                }
                timedOut = true;
                continue;
            }
            catch (InterruptedException retry) {
                timedOut = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWorker(Worker w) {
        Thread wt = Thread.currentThread();
        Runnable task = w.firstTask;
        w.firstTask = null;
        w.unlock();
        boolean completedAbruptly = true;
        try {
            while (task != null || (task = this.getTask()) != null) {
                w.lock();
                if ((ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000) || Thread.interrupted() && ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000)) && !wt.isInterrupted()) {
                    wt.interrupt();
                }
                try {
                    this.beforeExecute(wt, task);
                    Throwable thrown = null;
                    try {
                        task.run();
                    }
                    catch (RuntimeException x) {
                        thrown = x;
                        throw x;
                    }
                    catch (Error x) {
                        thrown = x;
                        throw x;
                    }
                    catch (Throwable x) {
                        thrown = x;
                        throw new Error(x);
                    }
                    finally {
                        this.afterExecute(task, thrown);
                    }
                }
                finally {
                    task = null;
                    ++w.completedTasks;
                    w.unlock();
                }
            }
            completedAbruptly = false;
        }
        finally {
            this.processWorkerExit(w, completedAbruptly);
        }
    }

    public ThreadPoolExecutor(String region, String poolName, ThreadPoolStrategyImpl strategy) {
        this.region = region;
        this.poolName = poolName;
        this.strategy = strategy;
        this.workQueue = new MultiTaskBlockingQueue(Integer.MAX_VALUE);
        strategy.getFullTaskTypeList().forEach(taskType -> this.workQueue.addTaskType((FullTaskType)taskType));
        if (strategy.getMinThreadNum() < 0 || strategy.getMaxThreadNum() <= 0 || strategy.getMaxThreadNum() < strategy.getMinThreadNum() || strategy.getThreadIdeMinutes() < 0L) {
            throw new IllegalArgumentException();
        }
        this.acc = System.getSecurityManager() == null ? null : AccessController.getContext();
        this.corePoolSize = strategy.getMinThreadNum();
        this.maximumPoolSize = strategy.getMaxThreadNum() + strategy.getOverflowThreadNum();
        this.keepAliveTime = TimeUnit.MINUTES.toNanos(strategy.getThreadIdeMinutes());
        this.threadFactory = new DefaultThreadFactory(region, poolName, this.THREAD_NUMBER);
        this.handler = strategy.getRejectedExecutionHandler() == null ? defaultHandler : strategy.getRejectedExecutionHandler();
    }

    ThreadPoolStrategyImpl getTreadPoolStrategy() {
        return this.strategy;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadPoolStrategy(ThreadPoolStrategyImpl strategy) {
        if (strategy.validate()) {
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                this.strategy = strategy;
                this.setCorePoolSize(strategy.getMinThreadNum());
                this.setMaximumPoolSize(strategy.getMaxThreadNum() + strategy.getOverflowThreadNum());
                this.setKeepAliveTime(strategy.getThreadIdeMinutes(), TimeUnit.MINUTES);
                List<FullTaskType> typeList = strategy.getFullTaskTypeList();
                for (FullTaskType type : typeList) {
                    FullTaskType t = this.workQueue.getTaskType(type.getName());
                    if (t == null) continue;
                    this.workQueue.changeTaskTypeMapping(t.getName(), t.getPriority(), type.getPriority());
                    t.setPriority(type.getPriority());
                    t.setLimitType(type.getLimitType());
                    t.setMaxThreadRate(type.getMaxThreadRate());
                    t.setMaxThreadNum(type.getMaxThreadNum());
                    t.setTaskQueueMaxSize(type.getTaskQueueMaxSize());
                    t.setCanRun(type.isCanRun());
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    public ThreadPoolStrategyImpl getStrategy() {
        return this.strategy;
    }

    @Override
    public void addTaskType(TaskType taskType) {
        FullTaskType fullTaskType = this.strategy.validateTaskType(FullTaskType.newTaskTypeFor(taskType));
        this.strategy.register(taskType);
        this.workQueue.addTaskType(fullTaskType);
    }

    @Override
    public void removeTaskType(String registeredTaskTypeName) {
        FullTaskType fullTaskType = this.workQueue.getTaskType(registeredTaskTypeName);
        if (fullTaskType == null) {
            return;
        }
        this.strategy.getFullTaskTypeList().remove(fullTaskType);
        this.workQueue.removeTaskType(fullTaskType);
    }

    @Override
    public TaskType getTaskType(String registeredTaskTypeName) {
        FullTaskType t = this.workQueue.getTaskType(registeredTaskTypeName);
        return FullTaskType.convert(t);
    }

    @Override
    public List<TaskType> getAllTaskType() {
        Collection<FullTaskType> all = this.workQueue.getAllTaskType();
        ArrayList<TaskType> ret = new ArrayList<TaskType>(all.size());
        all.forEach(f -> ret.add(FullTaskType.convert(f)));
        return ret;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        FullTaskType fullTaskType = this.getTaskType(command);
        if (fullTaskType == null) {
            this.reject(command);
            return;
        }
        int c = this.ctl.get();
        if (ThreadPoolExecutor.workerCountOf(c) < this.corePoolSize) {
            if (this.addWorker(command, true)) {
                return;
            }
            c = this.ctl.get();
        }
        if (ThreadPoolExecutor.isRunning(c) && this.workQueue.offer(command, fullTaskType.getName())) {
            int recheck = this.ctl.get();
            if (!ThreadPoolExecutor.isRunning(recheck) && this.remove(command)) {
                this.reject(command);
            } else if (ThreadPoolExecutor.workerCountOf(recheck) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(command, false)) {
            this.reject(command);
        }
    }

    @Override
    public void shutdown() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptIdleWorkers();
            this.onShutdown();
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> tasks;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0x20000000);
            this.interruptWorkers();
            tasks = this.drainQueue();
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        return tasks;
    }

    @Override
    public boolean isShutdown() {
        return !ThreadPoolExecutor.isRunning(this.ctl.get());
    }

    public boolean isTerminating() {
        int c = this.ctl.get();
        return !ThreadPoolExecutor.isRunning(c) && ThreadPoolExecutor.runStateLessThan(c, 0x60000000);
    }

    @Override
    public boolean isTerminated() {
        return ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            while (true) {
                if (ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x60000000)) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void finalize() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null || this.acc == null) {
            this.shutdown();
        } else {
            PrivilegedAction<Void> pa = () -> {
                this.shutdown();
                return null;
            };
            AccessController.doPrivileged(pa, this.acc);
        }
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setPoolRejectedExecutionHandler(PoolRejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public PoolRejectedExecutionHandler getPoolRejectedExecutionHandler() {
        return this.handler;
    }

    public void setCorePoolSize(int corePoolSize) {
        block3: {
            int delta;
            block2: {
                if (corePoolSize < 0) {
                    throw new IllegalArgumentException();
                }
                delta = corePoolSize - this.corePoolSize;
                this.corePoolSize = corePoolSize;
                if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) <= corePoolSize) break block2;
                this.interruptIdleWorkers();
                break block3;
            }
            if (delta <= 0) break block3;
            int k = Math.min(delta, this.workQueue.size());
            while (k-- > 0 && this.addWorker(null, true) && !this.workQueue.isEmpty()) {
            }
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return ThreadPoolExecutor.workerCountOf(this.ctl.get()) < this.corePoolSize && this.addWorker(null, true);
    }

    void ensurePrestart() {
        int wc = ThreadPoolExecutor.workerCountOf(this.ctl.get());
        if (wc < this.corePoolSize) {
            this.addWorker(null, true);
        } else if (wc == 0) {
            this.addWorker(null, false);
        }
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addWorker(null, true)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean value) {
        if (value && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        if (value != this.allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = value;
            if (value) {
                this.interruptIdleWorkers();
            }
        }
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize = maximumPoolSize;
        if (ThreadPoolExecutor.workerCountOf(this.ctl.get()) > maximumPoolSize) {
            this.interruptIdleWorkers();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        if (time == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        long keepAliveTime = unit.toNanos(time);
        long delta = keepAliveTime - this.keepAliveTime;
        this.keepAliveTime = keepAliveTime;
        if (delta < 0L) {
            this.interruptIdleWorkers();
        }
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public MultiTaskBlockingQueue getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        FullTaskType type = this.getTaskType(task);
        boolean removed = this.workQueue.remove(task, type.getName());
        this.tryTerminate();
        return removed;
    }

    public Runnable pollTask(Runnable task) {
        FullTaskType type = this.getTaskType(task);
        if (type != null) {
            return this.workQueue.poll(type.getName());
        }
        return null;
    }

    public int getPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x40000000) ? 0 : this.workers.size();
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            for (Worker w : this.workers) {
                if (!w.isLocked()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
                if (!w.isLocked()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
            }
            long l = n;
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    public long getRejectedTaskCount() {
        return this.rejectedTaskCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int nworkers;
        int nactive;
        long ncompleted;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            ncompleted = this.completedTaskCount;
            nactive = 0;
            nworkers = this.workers.size();
            for (Worker w : this.workers) {
                ncompleted += w.completedTasks;
                if (!w.isLocked()) continue;
                ++nactive;
            }
        }
        finally {
            mainLock.unlock();
        }
        int c = this.ctl.get();
        String rs = ThreadPoolExecutor.runStateLessThan(c, 0) ? "Running" : (ThreadPoolExecutor.runStateAtLeast(c, 0x60000000) ? "Terminated" : "Shutting down");
        return super.toString() + "[" + rs + ", pool size = " + nworkers + ", active threads = " + nactive + ", queued tasks = " + this.workQueue.size() + ", completed tasks = " + ncompleted + "]";
    }

    protected void beforeExecute(Thread t, Runnable r) {
        FullTaskType type = this.getTaskType(r);
        long currTime = System.nanoTime();
        if (!type.isFromQueue()) {
            type.incrementActiveThreadCount();
        } else {
            long inQueueTime = 0L;
            if (r instanceof TaskRunnable) {
                TaskRunnable runnable = (TaskRunnable)r;
                inQueueTime = (currTime - runnable.inQueueNanoTime()) / 1000000L;
            } else if (r instanceof FutureTaskWrap) {
                FutureTaskWrap future = (FutureTaskWrap)r;
                inQueueTime = (currTime - future.inQueueNanoTime()) / 1000000L;
            }
            type.addInQueueTotalMilliTime(inQueueTime);
        }
        this.startNanoTimeMap.put(String.valueOf(r.hashCode()), currTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterExecute(Runnable r, Throwable t) {
        FullTaskType type = this.getTaskType(r);
        if (t == null) {
            type.incrementExecutedTotalCount();
        }
        String key = String.valueOf(r.hashCode());
        try {
            long executeEndNano = System.nanoTime();
            Long executeStartNano = this.startNanoTimeMap.remove(key);
            if (executeStartNano != null) {
                long executeTime = (executeEndNano - executeStartNano) / 1000000L;
                type.addExecutedTotalMilliTime(executeTime);
            }
        }
        finally {
            type.decrementActiveThreadCount();
            type.removeQueueTag();
        }
    }

    protected void terminated() {
    }

    private final class Worker
    extends AbstractQueuedSynchronizer
    implements Runnable {
        private static final long serialVersionUID = 6138294804551838833L;
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable firstTask) {
            this.setState(-1);
            this.firstTask = firstTask;
            this.thread = ThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }

        @Override
        public void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() != 0;
        }

        @Override
        protected boolean tryAcquire(int unused) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected boolean tryRelease(int unused) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        public void lock() {
            this.acquire(1);
        }

        public boolean tryLock() {
            return this.tryAcquire(1);
        }

        public void unlock() {
            this.release(1);
        }

        public boolean isLocked() {
            return this.isHeldExclusively();
        }

        void interruptIfStarted() {
            Thread t;
            if (this.getState() >= 0 && (t = this.thread) != null && !t.isInterrupted()) {
                try {
                    t.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    private static class TaskCallable<T>
    implements Callable<T>,
    Serializable {
        Callable<T> callable;
        String taskType;
        long inQueueNanoTime;
        RequestContext context;
        OperationContext oc;

        public TaskCallable(Callable<T> callable, String taskType) {
            this.callable = callable;
            this.taskType = taskType;
            this.inQueueNanoTime = System.nanoTime();
        }

        public long inQueueNanoTime() {
            return this.inQueueNanoTime;
        }

        public void setContext(RequestContext context) {
            this.context = RequestContext.copy((RequestContext)context);
        }

        public void setOc(OperationContext oc) {
            this.oc = oc;
        }

        @Override
        public T call() throws Exception {
            if (this.context != null) {
                RequestContextCreator.restoreForThreadPool((RequestContext)this.context);
                this.context.setTraceId(RequestContext.get().getTraceId());
                SetThreadName.setTraceId((String)RequestContext.get().getTraceId());
                String threadName = Thread.currentThread().getName();
                int index = threadName.indexOf("/");
                String tempName = threadName;
                if (index > 0) {
                    tempName = threadName.substring(0, index);
                }
                try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)tempName);){
                    span.addTag("threadName", threadName);
                    span.addTag("tenantId", this.context.getTenantId());
                    span.addTag("accountId", this.context.getAccountId());
                    if (this.oc != null) {
                        OperationContext.set((OperationContext)this.oc);
                        span.addTag("appId", this.oc.getAppId());
                    }
                }
            }
            return this.callable.call();
        }
    }

    private static class FutureTaskWrap<V>
    extends FutureTask<V> {
        String taskType;
        long inQueueNanoTime;

        public FutureTaskWrap(Callable<V> callable, String taskType) {
            super(callable);
            this.taskType = taskType;
            this.inQueueNanoTime = System.nanoTime();
        }

        public FutureTaskWrap(Runnable runnable, V result, String taskType) {
            super(runnable, result);
            this.taskType = taskType;
            this.inQueueNanoTime = System.nanoTime();
        }

        public long inQueueNanoTime() {
            return this.inQueueNanoTime;
        }
    }

    private static class TaskRunnable
    implements Runnable {
        Runnable runnable;
        String taskType;
        long inQueueNanoTime;
        RequestContext context;
        OperationContext oc;

        public TaskRunnable(Runnable runnable, String taskType) {
            this.runnable = runnable;
            this.taskType = taskType;
            this.inQueueNanoTime = System.nanoTime();
        }

        public long inQueueNanoTime() {
            return this.inQueueNanoTime;
        }

        public void setContext(RequestContext context) {
            this.context = RequestContext.copy((RequestContext)context);
        }

        public void setOc(OperationContext oc) {
            this.oc = oc;
        }

        @Override
        public void run() {
            if (this.context != null) {
                RequestContextCreator.restoreForThreadPool((RequestContext)this.context);
                this.context.setTraceId(RequestContext.get().getTraceId());
                SetThreadName.setTraceId((String)RequestContext.get().getTraceId());
                String threadName = Thread.currentThread().getName();
                int index = threadName.indexOf("/");
                String tempName = threadName;
                if (index > 0) {
                    tempName = threadName.substring(0, index);
                }
                try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)tempName);){
                    span.addTag("threadName", threadName);
                    span.addTag("tenantId", this.context.getTenantId());
                    span.addTag("accountId", this.context.getAccountId());
                    if (this.oc != null) {
                        OperationContext.set((OperationContext)this.oc);
                        span.addTag("appId", this.oc.getAppId());
                    }
                }
            }
            this.runnable.run();
        }
    }
}

