/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.unifiedthreadpool.api.PoolRejectedExecutionHandler;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.exception.PoolErrorCode;
import kd.bos.unifiedthreadpool.exception.ThreadPoolStrategyException;
import kd.bos.unifiedthreadpool.tasktype.FullTaskType;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.TaskType;
import kd.bos.unifiedthreadpool.tasktype.ThreadLimitedModel;
import kd.bos.unifiedthreadpool.utils.AssertWithLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolStrategyImpl
implements ThreadPoolStrategy {
    public static int THREAD_MAX_THRESHOLD = 200;
    public static int THREAD_OVERFLOW_THRESHOLD = 50;
    public static int THREAD_TASK_TYPE_QUEUE_SIZE_THRESHOLD = 5000;
    private static final long THREAD_IDE_MINUTES_MIN_THRESHOLD = 1L;
    private static final long THREAD_IDE_MINUTES_MAX_THRESHOLD = 10L;
    private static final int DEFAULT_MIN_THREAD_NUM = 4;
    private static final int DEFAULT_MAX_THREAD_NUM = 8;
    private static final long DEFAULT_IDE_MINUTES = 1L;
    private static final int DEFAULT_MAX_OVERFLOW_NUM = 2;
    private static final int DEFAULT_THREAD_IDE_MINUTES = 1;
    private static final int DEFAULT_MAX_THREAD_NUM_TASK_TYPE = 1;
    private static final int DEFAULT_QUEUE_SIZE_TASK_TYPE = 100;
    private static final String DEFAULT_MAX_TASK_TYPE = "500";
    private static final String MAX_TASK_TYPE_CONFIG_KEY = "unifiedthreadpool.tasktype.limit";
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolStrategyImpl.class);
    private int maxThreadNum = 8;
    private int minThreadNum = 4;
    private int overflowThreadNum = 0;
    private long threadIdeMinutes = 1L;
    private PoolRejectedExecutionHandler rejectedExecutionHandler;
    private String poolName;
    private String region;
    private List<FullTaskType> fullTaskTypeList = new ArrayList<FullTaskType>(10);

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public int getMaxThreadNum() {
        return this.maxThreadNum;
    }

    @Override
    public ThreadPoolStrategyImpl setMaxThreadNum(int maxThreadNum) {
        this.maxThreadNum = maxThreadNum;
        return this;
    }

    public int getMinThreadNum() {
        return this.minThreadNum;
    }

    @Override
    public ThreadPoolStrategyImpl setMinThreadNum(int minThreadNum) {
        this.minThreadNum = minThreadNum;
        return this;
    }

    public int getOverflowThreadNum() {
        return this.overflowThreadNum;
    }

    @Override
    public ThreadPoolStrategyImpl setOverflowThreadNum(int overflowThreadNum) {
        this.overflowThreadNum = overflowThreadNum;
        return this;
    }

    @Override
    public ThreadPoolStrategy register(List<TaskType> taskTypeList) {
        if (taskTypeList != null && taskTypeList.size() > 0) {
            taskTypeList.forEach(taskType -> this.register((TaskType)taskType));
        }
        return this;
    }

    @Override
    public ThreadPoolStrategy register(TaskType taskType) {
        if (taskType == null) {
            throw new ThreadPoolStrategyException(PoolErrorCode.ILLEGAL_TASK_TYPE, "TaskType cannot be null.");
        }
        this.addFullTaskType(FullTaskType.newTaskTypeFor(taskType));
        return this;
    }

    public long getThreadIdeMinutes() {
        return this.threadIdeMinutes;
    }

    @Override
    public ThreadPoolStrategyImpl setThreadIdeMinutes(long threadIdeMinutes) {
        this.threadIdeMinutes = threadIdeMinutes;
        return this;
    }

    @Override
    public ThreadPoolStrategy setRejectedExecutionHandler(PoolRejectedExecutionHandler handler) {
        this.rejectedExecutionHandler = handler;
        return this;
    }

    public PoolRejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public ThreadPoolStrategyImpl setThreadIdeTime(int threadIdeTime) {
        this.threadIdeMinutes = threadIdeTime;
        return this;
    }

    public List<FullTaskType> getFullTaskTypeList() {
        return this.fullTaskTypeList;
    }

    public ThreadPoolStrategyImpl setFullTaskTypeList(List<FullTaskType> fullTaskTypeList) {
        this.fullTaskTypeList = fullTaskTypeList;
        this.taskSort();
        return this;
    }

    private ThreadPoolStrategyImpl() {
    }

    public static ThreadPoolStrategyImpl build() {
        return new ThreadPoolStrategyImpl();
    }

    @Override
    public boolean validate() {
        String error = "uthreadpool,region:%s,poolname:%s ";
        if (AssertWithLog.isNotNull(this.minThreadNum, error + "minThreadNum is null,set as default %s", this.region, this.poolName, 4)) {
            this.minThreadNum = 4;
        } else if (!AssertWithLog.gte(this.minThreadNum, 1, error + "minThreadNum: %s <1,set as default  %s", this.region, this.poolName, this.minThreadNum, 4)) {
            this.minThreadNum = 4;
        } else if (!AssertWithLog.gte(this.maxThreadNum, 1, error + "maxThreadNum: %s <1, set as default  %s", this.region, this.poolName, this.maxThreadNum, 8)) {
            this.maxThreadNum = 8;
        } else if (!AssertWithLog.lte(this.maxThreadNum, THREAD_MAX_THRESHOLD, error + "maxThreadNum: %s > max threshold: %s,set as max threshold value.", this.region, this.poolName, this.maxThreadNum, THREAD_MAX_THRESHOLD)) {
            this.maxThreadNum = THREAD_MAX_THRESHOLD;
        } else if (!AssertWithLog.gte(this.maxThreadNum, this.minThreadNum, error + "maxThreadNum: %s < minThreadNum: %s, set minThreadNum value as maxThreadNum.", this.region, this.poolName, this.maxThreadNum, this.minThreadNum)) {
            this.minThreadNum = this.maxThreadNum;
        } else if (!AssertWithLog.gte(this.overflowThreadNum, 0, error + "overflowThreadNum: %s < 0, set overflowThreadNum value as 0", this.region, this.poolName, this.overflowThreadNum)) {
            this.minThreadNum = 0;
        } else if (!AssertWithLog.lte(this.overflowThreadNum, THREAD_OVERFLOW_THRESHOLD, error + "overflowThreadNum %s > max threshold: %s,set as max threshold value.", this.region, this.poolName, this.overflowThreadNum, THREAD_OVERFLOW_THRESHOLD)) {
            this.overflowThreadNum = THREAD_OVERFLOW_THRESHOLD;
        } else if (!AssertWithLog.gte(this.threadIdeMinutes, 1, error + "threadIdeMinutes: %s <1, set as threshold min value %", this.region, this.poolName, this.threadIdeMinutes, 1L)) {
            this.threadIdeMinutes = 1L;
        } else if (!AssertWithLog.lte(this.threadIdeMinutes, 10L, error + "threadIdeMinutes: %s > maxThreshold: %s force to set as maxThreshold.", this.region, this.poolName, this.threadIdeMinutes, 10L)) {
            this.threadIdeMinutes = 10L;
        }
        AssertWithLog.isNotEmptyCollWithException(this.fullTaskTypeList, error + "taskTypeList can't be empty.", this.region, this.poolName);
        int maxTaskType = Integer.parseInt(System.getProperty(MAX_TASK_TYPE_CONFIG_KEY, DEFAULT_MAX_TASK_TYPE));
        if (this.fullTaskTypeList.size() > maxTaskType) {
            AssertWithLog.isIllegalParameterWithException(this.fullTaskTypeList.size(), error + "Task type exceeds the limit %s", this.region, this.poolName, DEFAULT_MAX_TASK_TYPE);
        }
        HashSet<String> names = new HashSet<String>(16);
        for (FullTaskType fullTaskType : this.fullTaskTypeList) {
            this.checkTaskType(names, fullTaskType);
        }
        return true;
    }

    public FullTaskType validateTaskType(FullTaskType fullTaskType) {
        Set<String> names = this.fullTaskTypeList.stream().map(FullTaskType::getName).collect(Collectors.toSet());
        return this.checkTaskType(names, fullTaskType);
    }

    private FullTaskType checkTaskType(Set<String> names, FullTaskType fullTaskType) {
        boolean isRatio;
        String error = "uthreadpool,region:%s,poolname:%s ";
        AssertWithLog.isNotEmptyWithException(fullTaskType.getName(), error + "taskType's name can't be empty!", this.region, this.poolName);
        String error0 = error + "taskType name:%s , ";
        if (names.contains(fullTaskType.getName())) {
            AssertWithLog.isIllegalParameterWithException(fullTaskType.getName(), error0 + " taskType's name can't be repeated!", this.region, this.poolName, fullTaskType.getName());
        }
        names.add(fullTaskType.getName());
        AssertWithLog.isNullWithException((Object)fullTaskType.getLimitType(), error0 + "limited  type can't be empty!", this.region, this.poolName, fullTaskType.getName());
        AssertWithLog.isNullWithException((Object)fullTaskType.getPriority(), error0 + "priority can't be empty!", this.region, this.poolName, fullTaskType.getName());
        AssertWithLog.gteWithException(fullTaskType.getPriority().getLevel(), Priority.ONE.getLevel(), error0 + "taskType priority: %s, must >=1 and <=10!", this.region, this.poolName, fullTaskType.getName(), fullTaskType.getPriority().getLevel());
        AssertWithLog.lteWithException(fullTaskType.getPriority().getLevel(), Priority.TEN.getLevel(), error0 + "priority: %s, must >=1 and <=10!", this.region, this.poolName, fullTaskType.getName(), fullTaskType.getPriority().getLevel());
        if (!AssertWithLog.gte(fullTaskType.getTaskQueueMaxSize(), 1, error0 + "queue size\uff1a %s <1 ,set as default value %s !", this.region, this.poolName, fullTaskType.getName(), fullTaskType.getTaskQueueMaxSize(), 100)) {
            fullTaskType.setTaskQueueMaxSize(100);
        } else if (!AssertWithLog.lte(fullTaskType.getTaskQueueMaxSize(), THREAD_TASK_TYPE_QUEUE_SIZE_THRESHOLD, error0 + " queue size\uff1a %s  > max threshold: %s ,set as max threshold\uff01.", this.region, this.poolName, fullTaskType.getName(), fullTaskType.getTaskQueueMaxSize(), THREAD_TASK_TYPE_QUEUE_SIZE_THRESHOLD)) {
            fullTaskType.setTaskQueueMaxSize(THREAD_TASK_TYPE_QUEUE_SIZE_THRESHOLD);
        }
        boolean bl = isRatio = ThreadLimitedModel.RATE == fullTaskType.getLimitType();
        if (isRatio) {
            String error1 = error0 + "thread limit with rate ";
            if (!AssertWithLog.gteForFloat(Float.valueOf(fullTaskType.getMaxThreadRate()), Float.valueOf(0.0f), error1 + "rate %s < 0 set as 0", this.region, this.poolName, fullTaskType.getName(), Float.valueOf(fullTaskType.getMaxThreadRate()))) {
                fullTaskType.setMaxThreadRate(0.0f);
            } else if (!AssertWithLog.lteForFloat(Float.valueOf(fullTaskType.getMaxThreadRate()), Float.valueOf(1.0f), error1 + "rate %s > 1.0 force to set as 1.0", this.region, this.poolName, fullTaskType.getName(), Float.valueOf(fullTaskType.getMaxThreadRate()))) {
                fullTaskType.setMaxThreadRate(1.0f);
            }
            int maxThread = Math.round((float)(this.maxThreadNum + this.overflowThreadNum) * fullTaskType.getMaxThreadRate());
            maxThread = maxThread == 0 ? 1 : maxThread;
            fullTaskType.setMaxThreadNum(maxThread);
        } else {
            String error2 = error0 + "thread limit with number ";
            if (!AssertWithLog.gte(fullTaskType.getMaxThreadNum(), 1, error2 + "maxThread\uff1a %s <0 ,set as default value %s !", this.region, this.poolName, fullTaskType.getName(), this.maxThreadNum, 1)) {
                fullTaskType.setMaxThreadNum(1);
            } else if (!AssertWithLog.lte(fullTaskType.getMaxThreadNum(), this.maxThreadNum + this.overflowThreadNum, error2 + "maxThread\uff1a %s  > maxThreadNum: %s + overflowThreadNum: %s ,set as maxThreadNum+ overflowThreadNum.", this.region, this.poolName, fullTaskType.getName(), fullTaskType.getMaxThreadNum(), this.maxThreadNum, this.overflowThreadNum)) {
                fullTaskType.setMaxThreadNum(this.maxThreadNum + this.overflowThreadNum);
            }
        }
        return fullTaskType;
    }

    private void addFullTaskType(FullTaskType fullTaskType) {
        String error = "uthreadpool,region:%s,poolname:%s ";
        int maxTaskType = Integer.parseInt(System.getProperty(MAX_TASK_TYPE_CONFIG_KEY, DEFAULT_MAX_TASK_TYPE));
        if (this.fullTaskTypeList.size() + 1 > maxTaskType) {
            AssertWithLog.isIllegalParameterWithException(this.fullTaskTypeList.size(), error + "Task type exceeds the limit %s", this.region, this.poolName, DEFAULT_MAX_TASK_TYPE);
        }
        this.fullTaskTypeList.add(fullTaskType);
        this.taskSort();
    }

    private void taskSort() {
        if (this.fullTaskTypeList != null && this.fullTaskTypeList.size() > 1) {
            Collections.sort(this.fullTaskTypeList, Comparator.comparing(FullTaskType::getPriority).reversed());
        }
    }
}

