/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.unifiedthreadpool.queue.SortedEntity;
import kd.bos.unifiedthreadpool.tasktype.FullTaskType;
import kd.bos.unifiedthreadpool.tasktype.Priority;

public class MultiTaskBlockingQueue {
    private ConcurrentHashMap<String, FullTaskType> taskMap = new ConcurrentHashMap(10);
    private List<FullTaskType> delList = new ArrayList<FullTaskType>(1);
    private List<SortedEntity> sortedPriority;
    private static final int PRIORITY_NUM = 10;
    private int capacity;
    private final AtomicInteger count = new AtomicInteger(0);
    private final ReentrantLock takeLock = new ReentrantLock();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final Condition notFull = this.putLock.newCondition();

    public MultiTaskBlockingQueue(int size) {
        this.capacity = size;
        ArrayList<SortedEntity> tmp = new ArrayList<SortedEntity>(10);
        for (Priority priority : Priority.values()) {
            tmp.add(new SortedEntity(priority));
        }
        this.sortedPriority = tmp.stream().sorted(Comparator.comparing(SortedEntity::getPriority).reversed()).collect(Collectors.toList());
    }

    public void addTaskType(FullTaskType task) {
        this.taskMap.put(task.getName(), task);
        SortedEntity sorted = this.getSortedEntity(task.getPriority());
        sorted.addTypeMapping(task.getName());
    }

    public void removeTaskType(FullTaskType taskType) {
        this.delList.add(taskType);
        taskType.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDeleted() {
        if (this.delList.isEmpty()) {
            return;
        }
        Iterator<FullTaskType> iterator = this.delList.iterator();
        while (iterator.hasNext()) {
            FullTaskType delObj = iterator.next();
            FullTaskType store = this.taskMap.get(delObj.getName());
            if (store == null || !store.isDeleted() || store.size() != 0) continue;
            this.fullyLock();
            try {
                if (store.size() != 0) continue;
                this.taskMap.remove(delObj.getName());
                SortedEntity sorted = this.getSortedEntity(delObj.getPriority());
                sorted.removeTypeMapping(delObj.getName());
                iterator.remove();
            }
            finally {
                this.fullyUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeTaskTypeMapping(String taskType, Priority original, Priority target) {
        if (target == original) {
            return;
        }
        this.fullyLock();
        try {
            SortedEntity fromEntity = this.getSortedEntity(original);
            fromEntity.removeTypeMapping(taskType);
            SortedEntity toEntity = this.getSortedEntity(target);
            toEntity.addTypeMapping(taskType);
        }
        finally {
            this.fullyUnlock();
        }
    }

    public FullTaskType getTaskType(String type) {
        return this.taskMap.get(type);
    }

    public Collection<FullTaskType> getAllTaskType() {
        return this.taskMap.values();
    }

    public void incrementActiveThreadCount(String type) {
        FullTaskType t = this.taskMap.get(type);
        if (t != null) {
            t.incrementActiveThreadCount();
        }
    }

    public void decrementActiveThreadCount(String type) {
        FullTaskType t = this.taskMap.get(type);
        if (t != null) {
            t.decrementActiveThreadCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Runnable obj, String type) {
        if (obj == null || type == null) {
            throw new NullPointerException();
        }
        if (this.count.get() >= this.capacity) {
            return false;
        }
        ReentrantLock putLock = this.putLock;
        AtomicInteger count = this.count;
        int c = -1;
        putLock.lock();
        try {
            FullTaskType task = this.taskMap.get(type);
            if (task.offer(obj) && (c = count.getAndIncrement()) + 1 < this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            putLock.unlock();
        }
        if (c == 0) {
            this.signalNotEmpty();
        }
        return c >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable take() throws InterruptedException {
        this.cleanDeleted();
        Runnable o = null;
        int c = -1;
        ReentrantLock lock = this.takeLock;
        AtomicInteger count = this.count;
        lock.lockInterruptibly();
        try {
            try {
                while (count.get() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            o = this.extract();
            c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            lock.unlock();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.cleanDeleted();
        Runnable o = null;
        int c = -1;
        long nanos = unit.toNanos(timeout);
        AtomicInteger count = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            while (count.get() == 0) {
                if (nanos <= 0L) {
                    Runnable runnable = null;
                    return runnable;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            o = this.extract();
            c = count.getAndDecrement();
            if (c > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            takeLock.unlock();
        }
        if (c == this.capacity) {
            this.signalNotFull();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable poll() {
        this.cleanDeleted();
        AtomicInteger count = this.count;
        if (count.get() == 0) {
            return null;
        }
        Runnable x = null;
        int c = -1;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            if (count.get() > 0) {
                x = this.extract();
                c = count.getAndDecrement();
                if (c > 1) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            takeLock.unlock();
        }
        if (c >= this.capacity) {
            this.signalNotFull();
        }
        return x;
    }

    public Runnable poll(String type) {
        FullTaskType fullTaskType = this.taskMap.get(type);
        if (fullTaskType == null) {
            return null;
        }
        return fullTaskType.pollTask();
    }

    public int size() {
        return this.count.get();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(Runnable o, String type) {
        FullTaskType fullTaskType = this.taskMap.get(type);
        if (o == null || fullTaskType == null) {
            return false;
        }
        return fullTaskType.remove(o);
    }

    public int drainTo(Collection<Runnable> c) {
        int n = 0;
        this.fullyLock();
        try {
            if (this.count.getAndSet(0) >= this.capacity) {
                this.notFull.signalAll();
            }
        }
        finally {
            this.fullyUnlock();
        }
        for (FullTaskType fullTaskType : this.taskMap.values()) {
            n += fullTaskType.drainTo(c);
        }
        return n;
    }

    private SortedEntity getSortedEntity(Priority priority) {
        int index = 10 - priority.getLevel();
        SortedEntity sorted = this.sortedPriority.get(index);
        return sorted;
    }

    private Runnable extract() {
        Runnable o = null;
        block0: do {
            for (SortedEntity entity : this.sortedPriority) {
                int curIndex;
                List<String> mapping = entity.getTypeMapping();
                int mappingSize = mapping.size();
                if (mappingSize == 0) continue;
                int beginIndex = curIndex = entity.currentIndex();
                do {
                    FullTaskType fullTaskType;
                    String key = mapping.get(curIndex);
                    if (++curIndex >= mappingSize) {
                        curIndex = 0;
                    }
                    if ((o = (fullTaskType = this.taskMap.get(key)).getTask()) == null) continue;
                    fullTaskType.incrementActiveThreadCount();
                    fullTaskType.setQueueTag();
                    break block0;
                } while (beginIndex != curIndex);
            }
        } while (o == null);
        return o;
    }

    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    private void signalNotFull() {
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            putLock.unlock();
        }
    }

    private void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    private void fullyUnlock() {
        this.putLock.unlock();
        this.takeLock.unlock();
    }
}

