/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.queue;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.unifiedthreadpool.tasktype.Priority;

public class SortedEntity {
    private Priority priority;
    private volatile AtomicInteger taskCount;
    private volatile AtomicInteger index;
    private List<String> typeMapping;

    public SortedEntity(Priority priority) {
        this.priority = priority;
        this.taskCount = new AtomicInteger(0);
        this.index = new AtomicInteger(0);
        this.typeMapping = new ArrayList<String>(16);
    }

    public Priority getPriority() {
        return this.priority;
    }

    public int currentIndex() {
        int current = this.index.getAndIncrement();
        if (current == this.typeMapping.size() - 1) {
            this.index.set(0);
        }
        return current;
    }

    public boolean removeTypeMapping(String taskType) {
        Iterator<String> iterator = this.typeMapping.iterator();
        boolean ret = false;
        while (iterator.hasNext()) {
            String type = iterator.next();
            if (!type.equals(taskType)) continue;
            iterator.remove();
            ret = true;
            this.index.set(0);
            break;
        }
        return ret;
    }

    public void addTypeMapping(String taskType) {
        if (!this.typeMapping.contains(taskType)) {
            this.typeMapping.add(taskType);
        }
    }

    public void incTaskCount() {
        this.taskCount.getAndIncrement();
    }

    public void decTaskCount() {
        this.taskCount.getAndDecrement();
    }

    public int getTaskCount() {
        return this.taskCount.get();
    }

    public List<String> getTypeMapping() {
        return this.typeMapping;
    }
}

