/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.instance.Instance;
import kd.bos.util.SAXReaderUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.WebPortUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigReader {
    private static Logger logger = LoggerFactory.getLogger(ConfigReader.class);
    private static final Map<String, PoolConfig> configs = new HashMap<String, PoolConfig>(6);
    private static final String CONFIG_PTAH = "kd/bos/unifiedthreadpool/threadpoolconfig.xml";
    private static final String SPLIT = "_";

    public static String getRegionDes(String region) {
        PoolConfig config = null;
        for (Map.Entry<String, PoolConfig> entry : configs.entrySet()) {
            PoolConfig val = entry.getValue();
            if (!val.region.equals(region)) continue;
            config = val;
            break;
        }
        String des = config == null ? "" : config.des;
        return des;
    }

    public static List<String> getRegionPools(String region) {
        ArrayList<String> pools = new ArrayList<String>(6);
        for (Map.Entry<String, PoolConfig> entry : configs.entrySet()) {
            PoolConfig val = entry.getValue();
            if (!val.region.equals(region)) continue;
            pools.add(val.poolName);
        }
        return pools;
    }

    public static boolean validate(String region, String poolName) {
        if (configs.isEmpty()) {
            ConfigReader.init();
        }
        String key = region + SPLIT + poolName;
        return configs.containsKey(key);
    }

    public static boolean isWebNode() {
        return WebPortUtil.isWebNode() && !Instance.isWebMserviceInOne();
    }

    private static void init() {
        String text = ConfigReader.getConfigText();
        try {
            Document document = SAXReaderUtil.parseText((String)text);
            List elements = document.getRootElement().elements();
            for (Element element : elements) {
                String region = element.attributeValue("name");
                String des = element.attributeValue("des");
                List child = element.elements();
                for (Element ch : child) {
                    String poolName = ch.attributeValue("name");
                    if (StringUtils.isEmpty((String)poolName)) {
                        poolName = ch.getText();
                    }
                    String key = region + SPLIT + poolName;
                    configs.put(key, new PoolConfig(region, des, poolName));
                }
            }
        }
        catch (Exception e) {
            logger.error("unifiedthreadpool threadpoolconfig.xml init error:{}", (Object)e.getMessage());
        }
    }

    private static String getConfigText() {
        StringBuilder text = new StringBuilder();
        try (InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(CONFIG_PTAH);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                text.append(line);
            }
        }
        catch (Exception e) {
            logger.error("unifiedthreadpool threadpoolconfig.xml init error:{}", (Object)e.getMessage());
        }
        return text.toString();
    }

    private static class PoolConfig {
        private String region;
        private String des;
        private String poolName;

        public PoolConfig(String region, String des, String poolName) {
            this.region = region;
            this.des = des;
            this.poolName = poolName;
        }
    }
}

