/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.input.executor;

import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.InputExecutor;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.input.DbInput;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DbInputExecutor
extends InputExecutor<DbInput> {
    private static final Log log = LogFactory.getLog(DbInputExecutor.class);
    private transient DataSet dataSet;

    public DbInputExecutor(DbInput input) {
        super((Input)input, input.getRowMeta());
    }

    public void close() {
        if (this.dataSet != null) {
            try {
                this.dataSet.close();
            }
            catch (Throwable t) {
                log.error("error when close DataSet", t);
            }
        }
    }

    public Row next() {
        if (!this.dataSet.hasNext()) {
            return null;
        }
        Row row = this.dataSet.next();
        return this.convertRow(row);
    }

    public void open() {
        RequestContext.set((RequestContext)((DbInput)this.input).getRequestContext());
        this.dataSet = DB.queryDataSet((String)((DbInput)this.input).getAlgoKey(), (DBRoute)DBRoute.of((String)((DbInput)this.input).getRouteKey()), (String)((DbInput)this.input).getSql(), (Object[])((DbInput)this.input).getParams());
    }

    public boolean hasNext() {
        return this.dataSet.hasNext();
    }

    protected Row convertRow(Row row) {
        if (this.dataTypes == null) {
            return row;
        }
        return RowFactory.createRow((RowMeta)this.rowMeta, (Object[])((AbstractRow)row).values());
    }
}

