/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.algo.AlgoException;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.JobNotFoundException;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.core.JobGraphTranslate;
import kd.bos.algox.jobclient.JobDetail;
import kd.bos.algox.jobclient.JobStatus;
import kd.bos.exception.KDException;
import kd.bos.util.ConfigurationUtil;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.util.SerializedThrowable;

public class ClusterClientMan {
    public static Object submitJob(JobGraph jobGraph, Configuration configuration, DispatcherGateway dispatcher, int timeoutSeconds) {
        Time time = Time.of((long)timeoutSeconds, (TimeUnit)TimeUnit.SECONDS);
        long start = System.currentTimeMillis();
        CompletableFuture future = dispatcher.submitJob(jobGraph, time);
        long cost = System.currentTimeMillis() - start;
        long timeout = time.toMilliseconds() - cost;
        if (timeout < 0L) {
            throw new CommitTimeoutException();
        }
        try {
            future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AlgoException("Error when submit job.", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new CommitTimeoutException(e.getMessage(), (Throwable)e);
        }
        return jobGraph.getJobID();
    }

    public static Object submitJob(JobContext context, Configuration configuration, DispatcherGateway dispatcher, int timeoutSeconds, boolean eagle) {
        JobGraph jobGraph = JobGraphTranslate.translate(context, configuration);
        if (context.isDisableLocalModel()) {
            jobGraph.getJobConfiguration().setBoolean("disableLocalMode", true);
        }
        return ClusterClientMan.submitJob(jobGraph, configuration, dispatcher, timeoutSeconds);
    }

    public static JobGraph createJobGraph(JobContext context, Configuration configuration) {
        return JobGraphTranslate.translate(context, configuration);
    }

    public static JobDetail getJobDetail(Object jobId, DispatcherGateway dispatcher) {
        try {
            int timeoutSeconds = 60;
            try {
                timeoutSeconds = ConfigurationUtil.getInteger((String)"algox.client.job.getDetailTimeout", (Integer)timeoutSeconds);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CompletableFuture future = dispatcher.requestJob((JobID)jobId, Time.seconds((long)timeoutSeconds));
            ArchivedExecutionGraph result = (ArchivedExecutionGraph)future.get();
            return ClusterClientMan.convertToDetail(result);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof FlinkJobNotFoundException) {
                throw new JobNotFoundException(jobId.toString(), e.getCause());
            }
            if (e.getCause() instanceof AlgoException) {
                throw new AlgoException("Error when get job detail: " + jobId + ",msg: " + e.getCause().getMessage(), (Throwable)e);
            }
            throw new AlgoException("Error when get job detail:" + jobId, e.getCause());
        }
        catch (Exception e) {
            throw new AlgoException("Error when get job detail:" + jobId, (Throwable)e);
        }
    }

    private static JobDetail convertToDetail(ArchivedExecutionGraph result) {
        org.apache.flink.api.common.JobStatus state = result.getState();
        ErrorInfo error = result.getFailureInfo();
        JobStatus status = ClusterClientMan.convertStatus(state);
        if (error != null) {
            SerializedThrowable t = error.getException();
            Throwable t2 = t;
            while ((t2 = t2.getCause()) != null) {
                if (t2 instanceof AlgoException) {
                    return new JobDetail(status, (Throwable)((AlgoException)t2));
                }
                if (!(t2 instanceof KDException)) continue;
                return new JobDetail(status, (Throwable)((KDException)t2));
            }
            t2 = t;
            while ((t2 = t2.getCause()) != null) {
                if (!(t2 instanceof JobException) || !(t2.getCause() instanceof RuntimeException)) continue;
                return new JobDetail(status, (Throwable)((RuntimeException)t2.getCause()));
            }
            String message = null;
            message = t instanceof SerializedThrowable ? t.getFullStringifiedStackTrace() : t.getMessage();
            return new JobDetail(status, (Throwable)new AlgoException(message, (Throwable)t));
        }
        return new JobDetail(status, (String)null);
    }

    private static JobStatus convertStatus(org.apache.flink.api.common.JobStatus state) {
        switch (state) {
            case FINISHED: {
                return JobStatus.FINISHED;
            }
            case FAILED: 
            case CANCELED: 
            case FAILING: 
            case CANCELLING: {
                return JobStatus.FAILED;
            }
        }
        return JobStatus.RUNNING;
    }
}

