/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.local;

import java.util.concurrent.locks.LockSupport;
import kd.bos.algox.AlgoXException;
import kd.bos.algox.cluster.ClusterClient;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.cluster.ClusterClientMan;
import kd.bos.algox.flink.cluster.local.LocalConfigurationLoader;
import kd.bos.algox.flink.cluster.local.LocalMasterRuntimeContext;
import kd.bos.algox.flink.cluster.local.LocalMasterStarter;
import kd.bos.algox.flink.cluster.local.LocalWorkerStarter;
import kd.bos.algox.jobclient.JobDetail;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;

public class LocalClusterClient
implements ClusterClient {
    public static final LocalClusterClient instance = new LocalClusterClient();
    private boolean enable = true;
    private boolean started;

    public LocalClusterClient() {
        if ("false".equals(System.getProperty("algox.local.enable"))) {
            this.enable = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ensureStart() {
        if (!this.started) {
            try {
                LocalMasterStarter.startup();
                LocalWorkerStarter.startup();
                int timeout = 60000;
                long startingTime = System.currentTimeMillis();
                Throwable t = null;
                while (LocalMasterRuntimeContext.getDispatcherGateway() == null && System.currentTimeMillis() - startingTime < (long)timeout) {
                    t = LocalMasterRuntimeContext.getException();
                    if (t != null) {
                        break;
                    }
                    LockSupport.parkNanos(100000000L);
                }
            }
            finally {
                this.started = true;
            }
        }
    }

    public Object submitJob(JobContext context, int timeoutSeconds) {
        if (!this.enable) {
            throw new AlgoXException("AlgoX local cluster disabled.");
        }
        this.ensureStart();
        Configuration configuration = LocalMasterRuntimeContext.getConfiguration();
        DispatcherGateway dispatcher = LocalMasterRuntimeContext.getDispatcherGateway();
        Throwable t = LocalMasterRuntimeContext.getException();
        if (dispatcher == null) {
            if (t != null) {
                throw new AlgoXException("Algox start error: " + t.getMessage(), t);
            }
            throw new AlgoXException("Algox not started, see starting log for detail.");
        }
        return ClusterClientMan.submitJob(context, configuration, dispatcher, timeoutSeconds, true);
    }

    public JobDetail getJobDetail(Object jobId) {
        return this.getJobDetail(jobId, null);
    }

    public boolean isLocal() {
        return true;
    }

    public String getMonitorUrl() {
        return this.getMonitorUrl(null);
    }

    public JobDetail getJobDetail(Object jobId, String region) {
        DispatcherGateway dispatcher = LocalMasterRuntimeContext.getDispatcherGateway();
        return ClusterClientMan.getJobDetail(jobId, dispatcher);
    }

    public String getMonitorUrl(String region) {
        return LocalConfigurationLoader.getWebUrl();
    }

    public boolean isAlgoXNode() {
        return this.started;
    }
}

