/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.masterworker;

import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import kd.bos.algo.AlgoException;
import kd.bos.algox.flink.cluster.masterworker.AlgoxHaType;
import kd.bos.algox.flink.cluster.masterworker.CommonConfigUtil;
import kd.bos.algox.flink.runtime.highavailability.redis.configuration.RedisHighAvailabilityOptions;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WebOptions;

public class MasterConfig {
    private static Configuration configuration = MasterConfig.getConfiguration();
    private static String webUrl;

    public static Configuration loadConfiguration() {
        return configuration;
    }

    private static Configuration getConfiguration() {
        String masterWebPortStr;
        String storageDir;
        String region = ConfigurationUtil.getString((String)"algox.cluster.region");
        boolean isDefaultRegion = StringUtils.isEmpty((String)region);
        String regionConfigKey = "algox.config";
        String regionConfig = null;
        if (isDefaultRegion) {
            region = "default";
            regionConfig = ConfigurationUtil.getString((String)regionConfigKey);
            if (StringUtils.isEmpty((String)regionConfig)) {
                return MasterConfig.getOldConfiguration();
            }
        } else {
            regionConfigKey = "algox.config." + region;
            regionConfig = ConfigurationUtil.getString((String)regionConfigKey, (String)"");
        }
        Properties properties = new Properties();
        StringReader reader = new StringReader(regionConfig);
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            throw new AlgoException(regionConfigKey + " load error:", (Throwable)e);
        }
        String clusterId = properties.getProperty("algox.cluster.name", Instance.getClusterName() + "_" + region);
        String zookeeper = properties.getProperty("algox.cluster.zookeeper");
        if (StringUtils.isEmpty((String)zookeeper)) {
            zookeeper = ConfigurationUtil.getString((String)"configUrl");
        }
        if ((storageDir = ConfigurationUtil.getString((String)"algox.cluster.storageDir")) == null) {
            storageDir = System.getProperty("java.io.tmpdir");
        }
        if (StringUtils.isEmpty((String)(masterWebPortStr = properties.getProperty("algox.master.webport", "7760")))) {
            throw new AlgoException("algox.master.webport in " + regionConfigKey + " can't be null.");
        }
        Integer masterWebPort = Integer.parseInt(masterWebPortStr);
        String masterHeapStr = properties.getProperty("algox.master.memory", "1024");
        Integer masterHeap = Integer.parseInt(masterHeapStr);
        return MasterConfig.buildConfiguration(clusterId, zookeeper, storageDir, masterWebPort, masterHeap);
    }

    private static Configuration getOldConfiguration() {
        String storageDir;
        String clusterId = ConfigurationUtil.getString((String)"algox.cluster.name", (String)Instance.getClusterName());
        String zookeeper = ConfigurationUtil.getString((String)"algox.cluster.zookeeper");
        if (zookeeper == null) {
            zookeeper = ConfigurationUtil.getString((String)"configUrl");
        }
        if ((storageDir = ConfigurationUtil.getString((String)"algox.cluster.storageDir")) == null) {
            storageDir = System.getProperty("java.io.tmpdir");
        }
        Integer masterWebPort = ConfigurationUtil.getInteger((String)"algox.master.webport", (Integer)7760);
        Integer masterHeap = ConfigurationUtil.getInteger((String)"algox.master.memory", (Integer)1024);
        return MasterConfig.buildConfiguration(clusterId, zookeeper, storageDir, masterWebPort, masterHeap);
    }

    private static Configuration buildConfiguration(String clusterId, String zookeeper, String storageDir, Integer masterWebPort, Integer masterHeap) {
        Configuration configuration = new Configuration();
        configuration.setInteger((ConfigOption<Integer>)RestOptions.PORT, (int)masterWebPort);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.PORT, (int)ConfigurationUtil.getInteger((String)"algox.local.master.port", (Integer)6123));
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID, clusterId);
        AlgoxHaType algoxHaType = AlgoxHaType.getAlgoxHaType();
        if (algoxHaType == AlgoxHaType.zookeeper) {
            configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_MODE, "zookeeper");
            configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zookeeper);
            String zkRootPath = ConfigurationUtil.getString((String)"algox.cluster.zkRootPath");
            if (zkRootPath != null) {
                if (zkRootPath.endsWith("/")) {
                    zkRootPath = zkRootPath.substring(0, zkRootPath.length() - 1);
                }
                configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_ROOT, zkRootPath);
            }
        } else if (algoxHaType == AlgoxHaType.redis) {
            configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_MODE, "kd.bos.algox.flink.runtime.highavailability.redis.RedisHaServiceFactory");
            String redisUrl = ConfigurationUtil.getString((String)"algox.cluster.redis.url");
            if (redisUrl == null) {
                redisUrl = System.getProperty(CacheConfigKeys.getSessionableConfigKey());
            }
            configuration.setString(RedisHighAvailabilityOptions.HA_REDIS_URL, redisUrl);
        }
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_STORAGE_PATH, storageDir);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.JOB_MANAGER_HEAP_MEMORY_MB, (int)masterHeap);
        configuration.set(JobManagerOptions.JOB_MANAGER_HEAP_MEMORY, MemorySize.ofMebiBytes((long)masterHeap.intValue()));
        Integer jobStore_cacheCount = ConfigurationUtil.getInteger((String)"algox.master.jobstore.cacheCount", (Integer)2000);
        Long jobStore_cacheSize = ConfigurationUtil.getLong((String)"algox.master.jobstore.cacheSize", (Long)0xC800000L);
        Long jobStore_expireTime = ConfigurationUtil.getLong((String)"algox.master.jobstore.expireTime", (Long)86400L);
        configuration.setInteger((ConfigOption<Integer>)JobManagerOptions.JOB_STORE_MAX_CAPACITY, (int)jobStore_cacheCount);
        configuration.setLong((ConfigOption<Long>)JobManagerOptions.JOB_STORE_CACHE_SIZE, (long)jobStore_cacheSize);
        configuration.setLong((ConfigOption<Long>)JobManagerOptions.JOB_STORE_EXPIRATION_TIME, (long)jobStore_expireTime);
        configuration.setBoolean(ClusterOptions.EVENLY_SPREAD_OUT_SLOTS_STRATEGY, true);
        String host = NetAddressUtils.getLocalIpAddress();
        if (host != null) {
            configuration.setString((ConfigOption<String>)JobManagerOptions.ADDRESS, host);
        }
        configuration.setBoolean((ConfigOption<Boolean>)JobManagerOptions.RETRIEVE_TASK_MANAGER_HOSTNAME, false);
        webUrl = "http://" + host + ":" + masterWebPort;
        Long l = ConfigurationUtil.getLong((String)"algox.web.refresh.interval", (Long)10000L);
        configuration.setLong((ConfigOption<Long>)WebOptions.REFRESH_INTERVAL, (long)l);
        CommonConfigUtil.buildCommon(configuration);
        return configuration;
    }

    public String getWebUrl() {
        return webUrl;
    }
}

