/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.masterworker;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algox.cluster.ClusterClient;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.cluster.ClusterClientMan;
import kd.bos.algox.flink.rpc.MasterRpcService;
import kd.bos.algox.flink.utils.ObjectSerde;
import kd.bos.algox.jobclient.JobDetail;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.service.register.ServiceRegister;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;

public class MasterWorkerClusterClient
implements ClusterClient {
    public static final MasterWorkerClusterClient instance = new MasterWorkerClusterClient();
    private static ConcurrentHashMap<String, String> regionGroupMap = new ConcurrentHashMap(8);

    public Object submitJob(JobContext context, int timeoutSeconds) {
        MasterRpcService service = MasterWorkerClusterClient.getMasterRpcService(context.getRegion());
        Configuration configuration = service.getMasterConfiguration();
        JobGraph jobGraph = ClusterClientMan.createJobGraph(context, configuration);
        jobGraph.getJobConfiguration().setBoolean("disableLocalMode", true);
        byte[] bytes = ObjectSerde.toBytes(jobGraph);
        return service.submitJob(bytes, timeoutSeconds);
    }

    public JobDetail getJobDetail(Object jobId) {
        return this.getJobDetail(jobId, null);
    }

    public boolean isLocal() {
        return false;
    }

    public String getMonitorUrl() {
        return this.getMonitorUrl(null);
    }

    public JobDetail getJobDetail(Object jobId, String region) {
        return MasterWorkerClusterClient.getMasterRpcService(region).getJobDetail(jobId);
    }

    public String getMonitorUrl(String region) {
        MasterRpcService service = MasterWorkerClusterClient.getMasterRpcService(region);
        return service.getWebUrl();
    }

    public static MasterRpcService getMasterRpcService(String region) {
        String groupName = null;
        if (StringUtils.isNotEmpty((String)region) && !"default".equals(region)) {
            groupName = regionGroupMap.get(region);
            if (groupName == null) {
                MasterRpcService service = (MasterRpcService)ServiceLookup.lookup(MasterRpcService.class, (String)region);
                try {
                    service.isAvailable();
                    groupName = region;
                    regionGroupMap.putIfAbsent(region, groupName);
                }
                catch (Exception e) {
                    groupName = "default";
                }
            }
        } else {
            groupName = "default";
        }
        return (MasterRpcService)ServiceLookup.lookup(MasterRpcService.class, (String)groupName);
    }

    public boolean isAlgoXNode() {
        return "true".equals(System.getProperty("algox.master.enable")) || "true".equals(System.getProperty("algox.worker.enable"));
    }

    static {
        ServiceRegister.registerConsumer((String)"MasterRpcService", (String)"interface=kd.bos.algox.flink.rpc.MasterRpcService");
    }
}

