/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.masterworker;

import java.io.IOException;
import java.io.StringReader;
import java.time.Duration;
import java.util.Properties;
import kd.bos.algo.AlgoException;
import kd.bos.algox.flink.cluster.masterworker.AlgoxHaType;
import kd.bos.algox.flink.cluster.masterworker.CommonConfigUtil;
import kd.bos.algox.flink.runtime.highavailability.redis.configuration.RedisHighAvailabilityOptions;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.NetAddressUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.flink.configuration.AlgorithmOptions;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;

public class WorkerConfig {
    public static Configuration loadConfiguration() {
        String storageDir;
        String region = ConfigurationUtil.getString((String)"algox.cluster.region");
        boolean isDefaultRegion = StringUtils.isEmpty((String)region);
        String regionConfigKey = "algox.config";
        String regionConfig = null;
        if (isDefaultRegion) {
            region = "default";
            regionConfig = ConfigurationUtil.getString((String)regionConfigKey);
            if (StringUtils.isEmpty((String)regionConfig)) {
                return WorkerConfig.getOldConfiguration();
            }
        } else {
            regionConfigKey = "algox.config." + region;
            regionConfig = ConfigurationUtil.getString((String)regionConfigKey, (String)"");
        }
        Properties properties = new Properties();
        StringReader reader = new StringReader(regionConfig);
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            throw new AlgoException(regionConfigKey + " load error:", (Throwable)e);
        }
        String clusterId = properties.getProperty("algox.cluster.name", Instance.getClusterName() + "_" + region);
        String zookeeper = properties.getProperty("algox.cluster.zookeeper");
        if (StringUtils.isEmpty((String)zookeeper)) {
            zookeeper = ConfigurationUtil.getString((String)"configUrl");
        }
        if ((storageDir = ConfigurationUtil.getString((String)"algox.cluster.storageDir")) == null) {
            storageDir = System.getProperty("java.io.tmpdir");
        }
        String workerHeapStr = properties.getProperty("algox.worker.memory", "2048");
        Integer workerHeap = Integer.parseInt(workerHeapStr);
        String workerSlotsStr = properties.getProperty("algox.worker.threads", "64");
        Integer workerSlots = Integer.parseInt(workerSlotsStr);
        return WorkerConfig.buildConfiguration(clusterId, zookeeper, storageDir, workerHeap, workerSlots);
    }

    private static Configuration getOldConfiguration() {
        String storageDir;
        String clusterId = ConfigurationUtil.getString((String)"algox.cluster.name", (String)Instance.getClusterName());
        String zookeeper = ConfigurationUtil.getString((String)"algox.cluster.zookeeper");
        if (zookeeper == null) {
            zookeeper = ConfigurationUtil.getString((String)"configUrl");
        }
        if ((storageDir = ConfigurationUtil.getString((String)"algox.cluster.storageDir")) == null) {
            storageDir = System.getProperty("java.io.tmpdir");
        }
        Integer workerHeap = ConfigurationUtil.getInteger((String)"algox.worker.memory", (Integer)4096);
        Integer workerSlots = ConfigurationUtil.getInteger((String)"algox.worker.threads", (Integer)32);
        return WorkerConfig.buildConfiguration(clusterId, zookeeper, storageDir, workerHeap, workerSlots);
    }

    private static Configuration buildConfiguration(String clusterId, String zookeeper, String storageDir, Integer workerHeap, Integer workerSlots) {
        Configuration configuration = new Configuration();
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID, clusterId);
        AlgoxHaType algoxHaType = AlgoxHaType.getAlgoxHaType();
        if (algoxHaType == AlgoxHaType.zookeeper) {
            configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_MODE, "zookeeper");
            configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, zookeeper);
            String zkRootPath = ConfigurationUtil.getString((String)"algox.cluster.zkRootPath");
            if (zkRootPath != null) {
                if (zkRootPath.endsWith("/")) {
                    zkRootPath = zkRootPath.substring(0, zkRootPath.length() - 1);
                }
                configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_ZOOKEEPER_ROOT, zkRootPath);
            }
        } else if (algoxHaType == AlgoxHaType.redis) {
            configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_MODE, "kd.bos.algox.flink.runtime.highavailability.redis.RedisHaServiceFactory");
            String redisUrl = ConfigurationUtil.getString((String)"algox.cluster.redis.url");
            if (redisUrl == null) {
                redisUrl = System.getProperty(CacheConfigKeys.getSessionableConfigKey());
            }
            configuration.setString(RedisHighAvailabilityOptions.HA_REDIS_URL, redisUrl);
        }
        configuration.setString((ConfigOption<String>)HighAvailabilityOptions.HA_STORAGE_PATH, storageDir);
        configuration.set(TaskManagerOptions.TASK_HEAP_MEMORY, MemorySize.ofMebiBytes((long)128L));
        configuration.set(TaskManagerOptions.MANAGED_MEMORY_SIZE, MemorySize.ofMebiBytes((long)workerHeap.intValue()));
        configuration.setBoolean(ClusterOptions.EVENLY_SPREAD_OUT_SLOTS_STRATEGY, true);
        configuration.setInteger((ConfigOption<Integer>)TaskManagerOptions.NUM_TASK_SLOTS, (int)workerSlots);
        configuration.set(TaskManagerOptions.SLOT_TIMEOUT, Duration.ofSeconds(60L));
        configuration.setDouble((ConfigOption<Double>)TaskManagerOptions.CPU_CORES, 4.0);
        String host = NetAddressUtils.getLocalIpAddress();
        if (host != null) {
            configuration.setString((ConfigOption<String>)TaskManagerOptions.HOST, host);
            configuration.set(TaskManagerOptions.HOST, host);
        }
        String memory = ConfigurationUtil.getString((String)"algox.worker.network.memory", (String)"2048");
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MAX, MemorySize.ofMebiBytes((long)Integer.parseInt(memory)));
        configuration.set(TaskManagerOptions.NETWORK_MEMORY_MIN, MemorySize.ofMebiBytes((long)Integer.parseInt(memory)));
        configuration.set(AlgorithmOptions.USE_LARGE_RECORDS_HANDLER, (Object)true);
        CommonConfigUtil.buildCommon(configuration);
        return configuration;
    }
}

