/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.cluster.masterworker;

import java.util.concurrent.Callable;
import kd.bos.algox.flink.cluster.masterworker.WorkerConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerStarter
extends TaskManagerRunner {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerStarter.class);
    private static boolean started;

    public WorkerStarter(Configuration configuration, PluginManager pluginManager, TaskManagerRunner.TaskExecutorServiceFactory taskExecutorServiceFactory) throws Exception {
        super(configuration, pluginManager, taskExecutorServiceFactory);
    }

    @Override
    public void onFatalError(Throwable exception) {
        LOG.error("Fatal error occurred while executing the TaskManager in flink worker.", exception);
        LOG.error("TaskManager initialization failed.", exception);
    }

    protected void terminateJVM() {
        LOG.error("Fatal error occurred, maybe need terminateJVM.");
    }

    public static void startup() {
        if (!Boolean.getBoolean("algox.worker.enable")) {
            LOG.warn("Algox worker disabled!");
            return;
        }
        if (started) {
            return;
        }
        started = true;
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"TaskManager", (String[])new String[0]);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            LOG.info("Maximum number of open file descriptors is {}.", (Object)maxOpenFileHandles);
        } else {
            LOG.info("Cannot determine the maximum number of open file descriptors");
        }
        final Configuration configuration = WorkerConfig.loadConfiguration();
        try {
            SecurityUtils.getInstalledContext().runSecured(new Callable(){

                public Void call() throws Exception {
                    WorkerStarter taskManagerRunner = new WorkerStarter(configuration, null, TaskManagerRunner::createTaskExecutorService);
                    taskManagerRunner.start();
                    return null;
                }
            });
        }
        catch (Exception t) {
            LOG.error("TaskManager initialization failed.", (Throwable)t);
        }
        catch (Error t) {
            LOG.error("TaskManager initialization failed.", (Throwable)t);
        }
    }
}

