/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core;

import kd.bos.algox.flink.core.InputEmptySemaphore;
import kd.bos.algox.flink.core.InputJdkSemaphore;
import kd.bos.algox.flink.core.InputSemaphore;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;

public class InputSemaphoreFactory {
    private static boolean semaphoreEnable = ConfigurationUtil.getBoolean((String)"algox.input.semaphore.enable", (Boolean)false);
    private static int inputCount = ConfigurationUtil.getInteger((String)"algox.input.semaphore.count", (Integer)20);
    private static InputSemaphore inputSemaphore;
    private static final Log logger;

    public static synchronized InputSemaphore getSemaphonre() {
        return inputSemaphore;
    }

    static {
        logger = LogFactory.getLog(InputSemaphore.class);
        inputSemaphore = semaphoreEnable ? new InputJdkSemaphore(inputCount) : new InputEmptySemaphore(inputCount);
        ConfigurationUtil.observeInteger((String)"algox.input.semaphore.count", (int)inputCount, v -> {
            Class<InputSemaphoreFactory> clazz = InputSemaphoreFactory.class;
            synchronized (InputSemaphoreFactory.class) {
                if (semaphoreEnable) {
                    int usedCount = inputCount - inputSemaphore.availablePermits();
                    InputJdkSemaphore newInputSemaphore = new InputJdkSemaphore((int)v);
                    try {
                        if (usedCount >= 0 && usedCount < v) {
                            newInputSemaphore.acquire(usedCount);
                        }
                        inputSemaphore = newInputSemaphore;
                    }
                    catch (InterruptedException e) {
                        logger.error("change semaphore count error", (Throwable)e);
                    }
                }
                inputCount = v;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
        ConfigurationUtil.observeBoolean((String)"algox.input.semaphore.enable", (boolean)semaphoreEnable, v -> {
            Class<InputSemaphoreFactory> clazz = InputSemaphoreFactory.class;
            synchronized (InputSemaphoreFactory.class) {
                if (!v.booleanValue()) {
                    InputEmptySemaphore newInputSemaphore = new InputEmptySemaphore(1);
                    inputSemaphore = newInputSemaphore;
                } else {
                    InputJdkSemaphore newInputSemaphore = new InputJdkSemaphore(inputCount);
                    inputSemaphore = newInputSemaphore;
                }
                semaphoreEnable = v;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        });
    }
}

