/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.inout;

import java.io.IOException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algox.RowX;
import kd.bos.algox.datachannel.ChannelRowOutput;
import kd.bos.algox.datachannel.DataChannels;
import kd.bos.algox.flink.core.inout.ParallelismConfigurable;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;

public class DataChannelOutputFormat
extends RichOutputFormat<RowX>
implements ParallelismConfigurable {
    private static final long serialVersionUID = -6742135867762478191L;
    private ChannelRowOutput output;
    private RowMeta rowMeta;
    private String channelId;

    public DataChannelOutputFormat(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.channelId = DataChannels.createChannelId();
    }

    public DataChannelOutputFormat(RowMeta rowMeta, String channelId) {
        this.rowMeta = rowMeta;
        this.channelId = channelId;
    }

    public void configure(Configuration configuration) {
    }

    public void open(int arg0, int arg1) throws IOException {
        this.output = DataChannels.createChannelRowOutput((String)this.channelId);
        this.output.open(this.rowMeta);
    }

    public void writeRecord(RowX out) throws IOException {
        Row row = this.convertToRow(out);
        this.output.write(row);
    }

    protected Row convertToRow(RowX out) {
        Object[] values = new Object[out.size()];
        for (int pos = 0; pos < out.size(); ++pos) {
            values[pos] = out.get(pos);
        }
        Row row = RowFactory.createRow((RowMeta)this.rowMeta, (Object[])values);
        return row;
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }

    public String getId() {
        return this.channelId;
    }

    @Override
    public int getParallelism() {
        return 1;
    }
}

