/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.myfunc;

import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.algox.flink.type.RowXTypeInfo;
import kd.bos.algox.flink.type.TypeUtil;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;

public class MyAddFieldsMapFunction
extends RichMapFunction<RowX, RowX>
implements ResultTypeQueryable<RowX> {
    private static final long serialVersionUID = 1L;
    private RowXTypeInfo typeInfo;
    private int[] sourceFieldIndexs;
    private int[] fieldIndexs;
    private int[] addFieldIndexs;
    private Object[] values;

    public MyAddFieldsMapFunction(RowMeta rowMeta, RowMeta sourceRowMeta, Field[] addFields, Object[] values) {
        this.typeInfo = TypeUtil.toRowXType(rowMeta);
        this.values = values;
        int count = sourceRowMeta.getFieldCount();
        this.sourceFieldIndexs = new int[count];
        this.fieldIndexs = new int[count];
        this.addFieldIndexs = new int[addFields.length];
        int flag = 0;
        for (Field field : sourceRowMeta.getFields()) {
            this.sourceFieldIndexs[flag] = sourceRowMeta.getFieldIndex(field.getName());
            this.fieldIndexs[flag] = rowMeta.getFieldIndex(field.getName());
            ++flag;
        }
        int addFlag = 0;
        for (Field field : addFields) {
            this.addFieldIndexs[addFlag] = rowMeta.getFieldIndex(field.getName());
            ++addFlag;
        }
    }

    public TypeInformation<RowX> getProducedType() {
        return this.typeInfo;
    }

    public RowX map(RowX row) throws Exception {
        int i;
        int sourceLen = this.sourceFieldIndexs.length;
        int addLen = this.addFieldIndexs.length;
        RowX result = new RowX(sourceLen + addLen);
        for (i = 0; i < sourceLen; ++i) {
            result.set(this.fieldIndexs[i], row.get(this.sourceFieldIndexs[i]));
        }
        for (i = 0; i < addLen; ++i) {
            result.set(this.addFieldIndexs[i], this.values[i]);
        }
        return result;
    }
}

