/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.core.myfunc;

import java.util.Optional;
import kd.bos.algo.RowFeature;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.sql.parser.SqlParser;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.agg.CountExpr;
import kd.bos.algo.sql.tree.agg.MaxExpr;
import kd.bos.algo.sql.tree.agg.MinExpr;
import kd.bos.algo.sql.tree.agg.SumExpr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;
import kd.bos.algo.util.Aggregator;
import kd.bos.algox.RowX;
import kd.bos.algox.core.AggField;
import kd.bos.algox.flink.type.RowXTypeInfo;
import kd.bos.algox.flink.type.TypeUtil;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;

public class MyAggregatorFunction
extends RichGroupReduceFunction<RowX, RowX>
implements ResultTypeQueryable<RowX> {
    private static final long serialVersionUID = 1L;
    private RowXTypeInfo typeInfo;
    private Aggregator[] aggregators;
    private int[] fieldPositions;
    private final int[] groupByIndexes;
    private AggField[] aggFields;
    private Calc[] aggCalcs;
    private RowMeta sourceMeta;
    private int aggBeginPos = -1;

    public MyAggregatorFunction(RowMeta sourceMeta, RowMeta rowMeta, int[] groupByIndexes, AggField[] aggFields) {
        this.sourceMeta = sourceMeta;
        this.groupByIndexes = groupByIndexes;
        this.aggFields = aggFields;
        this.typeInfo = TypeUtil.toRowXType(rowMeta);
        this.fieldPositions = new int[aggFields.length];
        this.aggBeginPos = groupByIndexes.length;
        for (int i = 0; i < aggFields.length; ++i) {
            this.fieldPositions[i] = sourceMeta.getFieldIndex(aggFields[i].field);
        }
    }

    public TypeInformation<RowX> getProducedType() {
        return this.typeInfo;
    }

    public void open(Configuration parameters) throws Exception {
        this.aggregators = new Aggregator[this.aggFields.length];
        for (int i = 0; i < this.aggFields.length; ++i) {
            this.aggregators[i] = Aggregator.getAggregator((String)this.aggFields[i].getFuncName());
        }
        this.initAggExpr();
    }

    private void initAggExpr() {
        SqlParser parser = new SqlParser();
        Expr[] exprs = new Expr[this.aggFields.length];
        for (int i = 0; i < this.aggFields.length; ++i) {
            AggField aggField = this.aggFields[i];
            exprs[i] = this.getAggExpr(aggField, parser);
        }
        ExprParser exprParser = new ExprParser(this.sourceMeta);
        Alias[] aggAliasExprs = exprParser.transformAlias(exprParser.resolve(exprs));
        this.aggCalcs = new Calc[this.aggregators.length];
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggCalcs[i] = CalcCompiler.compile((RowMeta)this.sourceMeta, (Expr)aggAliasExprs[i]);
        }
    }

    private Expr getAggExpr(AggField aggField, SqlParser parser) {
        switch (aggField.func) {
            case 0: {
                Expr child = parser.parseExpr(aggField.field);
                Optional<NodeLocation> op = Optional.of(new NodeLocation(aggField.field));
                SumExpr expr = new SumExpr(op, child);
                if (aggField.alias != null) {
                    expr = new Alias(op, (Expr)expr, aggField.alias);
                }
                return expr;
            }
            case 2: {
                Expr child = parser.parseExpr(aggField.field);
                Optional<NodeLocation> op = Optional.of(new NodeLocation(aggField.field));
                MaxExpr expr = new MaxExpr(op, child);
                if (aggField.alias != null) {
                    expr = new Alias(op, (Expr)expr, aggField.alias);
                }
                return expr;
            }
            case 3: {
                Expr child = parser.parseExpr(aggField.field);
                Optional<NodeLocation> op = Optional.of(new NodeLocation(aggField.field));
                MinExpr expr = new MinExpr(op, child);
                if (aggField.alias != null) {
                    expr = new Alias(op, (Expr)expr, aggField.alias);
                }
                return expr;
            }
            case 1: {
                Expr child = parser.parseExpr(aggField.field);
                Optional<NodeLocation> op = Optional.of(new NodeLocation(aggField.field));
                CountExpr expr = new CountExpr(op, child);
                if (aggField.alias != null) {
                    expr = new Alias(op, (Expr)expr, aggField.alias);
                }
                return expr;
            }
        }
        throw new UnsupportedOperationException("Unsupported aggField function: " + aggField.func);
    }

    public void reduce(Iterable<RowX> iter, Collector<RowX> collector) throws Exception {
        Object[] retValues = null;
        for (RowX row : iter) {
            int i;
            if (retValues == null) {
                retValues = new Object[this.typeInfo.getFieldNames().length];
                for (i = 0; i < this.groupByIndexes.length; ++i) {
                    retValues[i] = row.get(this.groupByIndexes[i]);
                }
            }
            for (i = 0; i < this.aggregators.length; ++i) {
                Object value = this.aggCalcs[i].execute((RowFeature)row, null);
                retValues[this.aggBeginPos + i] = this.aggregators[i].appendValue(retValues[this.aggBeginPos + i], value);
            }
        }
        if (retValues != null) {
            for (int i = 0; i < this.aggregators.length; ++i) {
                retValues[this.aggBeginPos + i] = this.aggregators[i].getValue(retValues[this.aggBeginPos + i]);
            }
            collector.collect((Object)new RowX(retValues));
        }
    }
}

