/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import kd.bos.algox.flink.enhance.krpc.PortInfo;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;

public class DispatcherConfig {
    private String bindAddress;
    private PortInfo port;
    @Deprecated
    private int dispatcherWorkerThreadCountMin = 2;
    @Deprecated
    private int dispatcherWorkerThreadCountMax = 4;
    @Deprecated
    private int dispatcherScheduleThreadCount = 1;
    @Deprecated
    private int clientNioEventLoopGroupThreadCount = 1;
    @Deprecated
    private int serverNioBossEventLoopGroupThreadCount = 1;
    @Deprecated
    private int serverNioWorkerEventLoopGroupThreadCount = 2;
    private int actorRefCheckTimeoutMillis = 1800000;
    private long maxFrameSize = 0x6400000L;
    private boolean tcpNoDelay = true;
    private int connectTimeout = 5000;

    public DispatcherConfig() {
    }

    public DispatcherConfig(String bindAddress, PortInfo port) {
        this.bindAddress = bindAddress;
        this.port = port;
    }

    public static long parseFrameSize(Configuration configuration) {
        Config cfg = ConfigFactory.parseString((String)("framesize=" + configuration.getString((ConfigOption<String>)AkkaOptions.FRAMESIZE)));
        return cfg.getMemorySize("framesize").toBytes();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setMaxFrameSize(long maxFrameSize) {
        if (maxFrameSize > Integer.MAX_VALUE) {
            maxFrameSize = 0x7FFFFFFEL;
        }
        this.maxFrameSize = maxFrameSize;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setPort(PortInfo port) {
        this.port = port;
    }

    public void setPort(int port) {
        this.port = port <= 0 ? new PortInfo(51000, 52000) : new PortInfo(port);
    }

    public void setDispatcherWorkerThreadCountMin(int dispatcherWorkerThreadCountMin) {
        this.dispatcherWorkerThreadCountMin = dispatcherWorkerThreadCountMin;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public PortInfo getPort() {
        return this.port;
    }

    public int getDispatcherWorkerThreadCountMin() {
        return this.dispatcherWorkerThreadCountMin;
    }

    public int getClientNioEventLoopGroupThreadCount() {
        return this.clientNioEventLoopGroupThreadCount;
    }

    public void setClientNioEventLoopGroupThreadCount(int clientNioEventLoopGroupThreadCount) {
        this.clientNioEventLoopGroupThreadCount = clientNioEventLoopGroupThreadCount;
    }

    public int getServerNioBossEventLoopGroupThreadCount() {
        return this.serverNioBossEventLoopGroupThreadCount;
    }

    public void setServerNioBossEventLoopGroupThreadCount(int serverNioBossEventLoopGroupThreadCount) {
        this.serverNioBossEventLoopGroupThreadCount = serverNioBossEventLoopGroupThreadCount;
    }

    public int getServerNioWorkerEventLoopGroupThreadCount() {
        return this.serverNioWorkerEventLoopGroupThreadCount;
    }

    public void setServerNioWorkerEventLoopGroupThreadCount(int serverNioWorkerEventLoopGroupThreadCount) {
        this.serverNioWorkerEventLoopGroupThreadCount = serverNioWorkerEventLoopGroupThreadCount;
    }

    public int getDispatcherScheduleThreadCount() {
        return this.dispatcherScheduleThreadCount;
    }

    public void setDispatcherScheduleThreadCount(int dispatcherScheduleThreadCount) {
        this.dispatcherScheduleThreadCount = dispatcherScheduleThreadCount;
    }

    public int getActorRefCheckTimeoutMillis() {
        return this.actorRefCheckTimeoutMillis;
    }

    public void setActorRefCheckTimeoutMillis(int actorRefCheckTimeoutMillis) {
        this.actorRefCheckTimeoutMillis = actorRefCheckTimeoutMillis;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getDispatcherWorkerThreadCountMax() {
        return this.dispatcherWorkerThreadCountMax;
    }

    public void setDispatcherWorkerThreadCountMax(int dispatcherWorkerThreadCountMax) {
        this.dispatcherWorkerThreadCountMax = dispatcherWorkerThreadCountMax;
    }

    public long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }
}

