/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl;

import java.text.MessageFormat;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kd.bos.algox.flink.enhance.krpc.ActorRef;
import kd.bos.algox.flink.enhance.krpc.Dispatcher;
import kd.bos.algox.flink.enhance.krpc.impl.LocalMsgPlus;
import kd.bos.algox.flink.enhance.krpc.impl.ReleasableResourceHolder;

public class LocalActorRef
implements ActorRef {
    private final ReleasableResourceHolder resourceHolder = new ReleasableResourceHolder();
    private final String endpoint;
    private final Dispatcher dispatcher;
    private final String clientEndpoint;
    private volatile long lastReadWriteTimestamp = System.currentTimeMillis();

    public LocalActorRef(String endpoint, Dispatcher dispatcher) {
        this.endpoint = endpoint;
        this.dispatcher = dispatcher;
        this.clientEndpoint = MessageFormat.format("local-client-{0}", UUID.randomUUID().toString().replaceAll("-", ""));
    }

    @Override
    public void addReleasableResource(AutoCloseable closeable) {
        this.resourceHolder.bind(closeable);
    }

    @Override
    public void tell(Object message) {
        LocalMsgPlus localMsgPlus = new LocalMsgPlus(message, this.dispatcher, this.clientEndpoint, this.endpoint);
        this.dispatcher.postMessage(localMsgPlus);
        this.updateLastReadWriteTimestamp();
    }

    @Override
    public CompletableFuture<Object> ask(Object message) {
        LocalMsgPlus localMsgPlus = new LocalMsgPlus(message, this.dispatcher, this.clientEndpoint, this.endpoint);
        this.dispatcher.postMessage(localMsgPlus);
        this.updateLastReadWriteTimestamp();
        return localMsgPlus.getFuture();
    }

    private void updateLastReadWriteTimestamp() {
        this.lastReadWriteTimestamp = System.currentTimeMillis();
    }

    @Override
    public String getClientEndpoint() {
        return this.clientEndpoint;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public String toString() {
        return "LocalActorRef{endpoint='" + this.endpoint + '\'' + ", clientEndpoint='" + this.clientEndpoint + '\'' + '}';
    }

    @Override
    public void close() {
        this.resourceHolder.close();
    }

    @Override
    public long getLastReadWriteTimestamp() {
        return this.lastReadWriteTimestamp;
    }
}

