/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.enhance.krpc.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algox.flink.enhance.krpc.Actor;
import kd.bos.algox.flink.enhance.krpc.MailBox;
import kd.bos.algox.flink.enhance.krpc.MsgPlus;
import kd.bos.algox.flink.enhance.krpc.impl.DispatcherImpl;
import kd.bos.algox.flink.enhance.krpc.impl.MailBoxImpl;
import kd.bos.algox.flink.enhance.krpc.impl.PoisonPill;
import kd.bos.algox.flink.enhance.krpc.impl.ReleasableResourceHolder;
import kd.bos.algox.flink.enhance.krpc.impl.ResponseMsgPlus;

public class VirtualActorImpl
implements Actor {
    private final ReleasableResourceHolder resourceHolder = new ReleasableResourceHolder();
    private final String endpointName;
    private final MailBox mailBox;
    private final AtomicBoolean terminate = new AtomicBoolean(false);

    public VirtualActorImpl(String endpointName) {
        this.endpointName = endpointName;
        this.mailBox = new MailBoxImpl(this);
    }

    @Override
    public void postMessage(MsgPlus msgPlus) {
        this.mailBox.postMessage(msgPlus);
    }

    @Override
    public boolean isInProcess() {
        return this.mailBox.isInProcess();
    }

    @Override
    public void process() {
        this.mailBox.process();
    }

    @Override
    public void handleMsgPlus(MsgPlus msgPlus) {
        if (this.terminate.get()) {
            DispatcherImpl.log.warn("Actor:{} has been terminate, will discard message:{}", (Object)this.endpointName, (Object)msgPlus);
            return;
        }
        if (msgPlus instanceof ResponseMsgPlus) {
            ResponseMsgPlus real = (ResponseMsgPlus)msgPlus;
            real.complete();
        } else if (msgPlus instanceof PoisonPill) {
            this.stop();
        } else {
            throw new UnsupportedOperationException("VirtualActorImpl only handle ResponseMsgPlus");
        }
    }

    private void stop() {
        this.terminate.set(true);
        this.resourceHolder.close();
        this.mailBox.shutdown();
    }

    @Override
    public CompletableFuture<Void> getActorTerminateFuture() {
        return this.resourceHolder.getCloseFuture();
    }

    public String toString() {
        return "VirtualActorImpl{endpointName='" + this.endpointName + '\'' + '}';
    }

    @Override
    public void addReleasableResource(AutoCloseable closeable) {
        this.resourceHolder.bind(closeable);
    }
}

