/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.jobclient;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import kd.bos.algox.monitor.AlgoXJobMonitor;
import kd.bos.algox.monitor.AlgoXJobMonitorFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;

public class AlgoXJobDetailsInfoUtil {
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));
    private static final Log logger = LogFactory.getLog(AlgoXJobDetailsInfoUtil.class);

    private static String getJobDetailsString(String jobId) {
        if (StringUtils.isEmpty((String)jobId)) {
            throw new IllegalArgumentException("argument \"jobId\" is empty");
        }
        String jobRequestPath = "/jobs/{jobID}".replace("{jobID}", jobId);
        String jobDetailsInfoJson = null;
        try {
            jobDetailsInfoJson = AlgoXJobDetailsInfoUtil.dbGetJobDetailsInfoJson(jobId);
            if (Objects.isNull(jobDetailsInfoJson)) {
                jobDetailsInfoJson = AlgoXJobDetailsInfoUtil.httpGetJobDetailsInfoJson(jobId, jobRequestPath);
            }
        }
        catch (Exception e) {
            logger.error("http get jobDetailsInfoJson error. ERROR_INFO: ", (Throwable)e);
        }
        return jobDetailsInfoJson;
    }

    public static boolean checkJobExists(String jobId) {
        String jobDetailsInfoJson = AlgoXJobDetailsInfoUtil.getJobDetailsString(jobId);
        return jobDetailsInfoJson != null;
    }

    public static JobDetailsInfo getJobDetailsInfo(String jobId) {
        String jobDetailsInfoJson = AlgoXJobDetailsInfoUtil.getJobDetailsString(jobId);
        JobDetailsInfo jobDetailsInfo = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            Objects.requireNonNull(jobDetailsInfoJson);
            jobDetailsInfo = (JobDetailsInfo)mapper.readValue(jobDetailsInfoJson, JobDetailsInfo.class);
        }
        catch (JsonProcessingException e) {
            logger.error("parse jobDetailsInfoJson to JobDetailsInfo is error. ERROR_INFO: ", (Throwable)e);
        }
        return jobDetailsInfo;
    }

    private static String httpGetJobDetailsInfoJson(String jobId, String path) throws Exception {
        String monitorUrl = AlgoXJobDetailsInfoUtil.getMasterUrlFromDB(jobId);
        String reqPath = monitorUrl + path;
        return HttpClientUtils.get((String)reqPath, (int)5000, (int)(READ_TIMEOUT * 1000));
    }

    private static String dbGetJobDetailsInfoJson(String jobId) {
        String jobDetailsString;
        AlgoXJobMonitor monitor = AlgoXJobMonitorFactory.getAlgoXJobMonitor();
        Map dataMap = monitor.query((Object)jobId);
        String jobDetailsInfoJson = null;
        Object jobDetails = dataMap.get("FJOBDETAILS");
        String string = jobDetailsString = jobDetails == null ? null : String.valueOf(jobDetails);
        if (StringUtils.isNotEmpty((String)jobDetailsString)) {
            try {
                Map jobDetailMap = (Map)JSONUtils.cast((String)jobDetailsString, Map.class);
                jobDetailsInfoJson = (String)jobDetailMap.get("/jobs/" + jobId);
            }
            catch (Exception e) {
                logger.error("parse jobDetails to JobDetails Map Object is error. ERROR_INFO: ", (Throwable)e);
            }
        }
        return jobDetailsInfoJson;
    }

    private static String getMasterUrlFromDB(String jobId) {
        AlgoXJobMonitor monitor = AlgoXJobMonitorFactory.getAlgoXJobMonitor();
        Map dataMap = monitor.query((Object)jobId);
        Object masterUrl = dataMap.get("FMASTERWEBURL");
        return String.valueOf(masterUrl);
    }
}

