/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.jobclient;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.AlgoException;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.CommitTimeoutException;
import kd.bos.algox.JobNotFoundException;
import kd.bos.algox.JobProgressListener;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.algox.cluster.ClusterClient;
import kd.bos.algox.cluster.ClusterFactory;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.jobclient.AlgoXJobDetailsInfoUtil;
import kd.bos.algox.jobclient.JobClient;
import kd.bos.algox.jobclient.JobDetail;
import kd.bos.algox.jobclient.JobStatus;
import kd.bos.algox.util.ReflectCallUtil;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.apache.flink.util.SerializedThrowable;

public class FlinkJobClient
implements JobClient {
    private static int waitInterval = ConfigurationUtil.getInteger((String)"algox.job.await.interval", (Integer)100);
    private static Log log = LogFactory.getLog(FlinkJobClient.class);

    private void setReadWriteModel(JobContext context) {
        ThreadReadWriteContext readWriteContext = ThreadReadWriteContext.get();
        if (readWriteContext != null) {
            context.setReadWriteMode(readWriteContext.getMode().name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(JobContext context, int commitTimeout, int runningTimeout, TimeUnit timeUnit) throws CommitTimeoutException, RunningTimeoutException {
        try {
            this.setReadWriteModel(context);
            ClusterClient cluster = ClusterFactory.getFactory().getClusterClient();
            Object jobId = cluster.submitJob(context, (int)timeUnit.toSeconds(commitTimeout));
            long ms = timeUnit.toMillis(runningTimeout);
            String title = context.getTitle();
            FlinkJobClient.syncWaitJob(jobId, title == null ? context.getJobName() : title, context.getRegion(), ms);
        }
        finally {
            context.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asyncCommit(JobContext context, int commitTimeout, int runningTimeout, TimeUnit timeUnit, AlgoXCallBack callback) {
        try {
            this.setReadWriteModel(context);
            ClusterClient cluster = ClusterFactory.getFactory().getClusterClient();
            Object jobId = cluster.submitJob(context, (int)timeUnit.toSeconds(commitTimeout));
            long ms = timeUnit.toMillis(runningTimeout);
            String title = context.getTitle();
            FlinkJobClient.asyncWaitJob(jobId, title == null ? context.getJobName() : title, context.getRegion(), ms, callback);
            String string = String.valueOf(jobId);
            return string;
        }
        finally {
            context.clear();
        }
    }

    public static void syncWaitJob(Object jobId, String title, String region, long timeoutMills) {
        JobProgressListener.start((Object)jobId, (String)title, (String)region);
        ClusterClient cluster = ClusterFactory.getFactory().getClusterClient();
        long endTime = timeoutMills + System.currentTimeMillis();
        do {
            block8: {
                try {
                    JobDetail jobDetail = cluster.getJobDetail(jobId, region);
                    if (jobDetail != null) {
                        JobStatus status = jobDetail.getStatus();
                        if (status == JobStatus.FINISHED) {
                            JobProgressListener.finished((Object)jobId, (String)title, (String)region);
                            return;
                        }
                        if (status == JobStatus.FAILED) {
                            JobProgressListener.failed((Object)jobId, (String)title, (String)region);
                            RuntimeException ex = FlinkJobClient.wrapException(jobDetail.getException(), jobId);
                            log.error("AlgoXError:", (Throwable)ex);
                            throw ex;
                        }
                    }
                }
                catch (RuntimeException e) {
                    JobProgressListener.failed((Object)jobId, (String)title, (String)region);
                    if (FlinkJobClient.isJobNotFoundException(e)) break block8;
                    throw e;
                }
            }
            try {
                Thread.sleep(waitInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < endTime);
        JobProgressListener.failed((Object)jobId, (String)title, (String)region);
        throw new RunningTimeoutException("Timeout when execute Job " + jobId);
    }

    private static RuntimeException wrapException(Throwable origin, Object jobId) {
        Throwable t = origin;
        while (t != null) {
            if (t instanceof AlgoException || t instanceof KDException) {
                return (RuntimeException)t;
            }
            if (t instanceof SerializedThrowable) {
                SerializedThrowable st = (SerializedThrowable)t;
                t = st.deserializeError(null);
                continue;
            }
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (t.getClass().getSimpleName().contains("Timeout")) {
                return new RunningTimeoutException("Error when execute Job " + jobId, t);
            }
            if (t == t.getCause()) {
                return new AlgoException("Error when execute Job " + jobId, t);
            }
            t = t.getCause();
        }
        return new AlgoException("Error when execute Job " + jobId, origin);
    }

    private static boolean isJobNotFoundException(Throwable e) {
        do {
            if (!(e instanceof JobNotFoundException)) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    public static void asyncWaitJob(final Object jobId, final String title, final String region, long timeoutMills, final AlgoXCallBack callback) {
        final long endTime = timeoutMills + System.currentTimeMillis();
        ReflectCallUtil.executeOnceIncludeRequestContext((String)("AlgoX" + jobId), (Runnable)new Runnable(){

            @Override
            public void run() {
                JobProgressListener.start((Object)jobId, (String)title, (String)region);
                ClusterClient cluster = ClusterFactory.getFactory().getClusterClient();
                do {
                    try {
                        JobDetail jobDetail = cluster.getJobDetail(jobId, region);
                        if (jobDetail != null) {
                            JobStatus status = jobDetail.getStatus();
                            if (status == JobStatus.FINISHED) {
                                JobProgressListener.finished((Object)jobId, (String)title, (String)region);
                                if (callback != null) {
                                    callback.onFinished();
                                }
                                return;
                            }
                            if (status == JobStatus.FAILED) {
                                if (jobDetail.getException() instanceof AlgoException) {
                                    throw (AlgoException)jobDetail.getException();
                                }
                                throw new AlgoException("Error when execute Job " + jobId, jobDetail.getException());
                            }
                        }
                    }
                    catch (Exception e) {
                        JobProgressListener.failed((Object)jobId, (String)title, (String)region);
                        if (callback != null) {
                            callback.onFailed(e);
                        }
                        return;
                    }
                    try {
                        Thread.sleep(waitInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (System.currentTimeMillis() < endTime);
                JobProgressListener.failed((Object)jobId, (String)title, (String)region);
                if (callback != null) {
                    callback.onFailed((Exception)new RunningTimeoutException("Timeout when execute Job " + jobId));
                }
            }
        });
    }

    public int getJobProgress(String jobId) {
        JobDetailsInfo jobDetailsInfo = AlgoXJobDetailsInfoUtil.getJobDetailsInfo(jobId);
        if (jobDetailsInfo == null) {
            return 0;
        }
        BigDecimal finishedJobCount = new BigDecimal(jobDetailsInfo.getJobVertexInfos().stream().filter(jobVertexDetailsInfo -> jobVertexDetailsInfo.getExecutionState() == ExecutionState.FINISHED).count());
        BigDecimal totalJobCount = new BigDecimal(jobDetailsInfo.getJobVertexInfos().size());
        return finishedJobCount.divide(totalJobCount, 2, 4).multiply(new BigDecimal(100)).intValue();
    }

    public boolean checkJobExists(String jobId) {
        return AlgoXJobDetailsInfoUtil.checkJobExists(jobId);
    }
}

