/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.rpc;

import kd.bos.algo.AlgoException;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.flink.cluster.ClusterClientMan;
import kd.bos.algox.flink.cluster.masterworker.MasterRuntimeContext;
import kd.bos.algox.flink.rpc.MasterRpcService;
import kd.bos.algox.flink.utils.ObjectSerde;
import kd.bos.algox.jobclient.JobDetail;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;

public class MasterRpcServiceImpl
implements MasterRpcService {
    @Override
    public JobDetail getJobDetail(Object jobId) {
        if (!MasterRuntimeContext.isEnable()) {
            throw new AlgoException("AlgoX master is disabled.");
        }
        DispatcherGateway dispatcher = MasterRuntimeContext.getDispatcherGateway();
        return ClusterClientMan.getJobDetail(jobId, dispatcher);
    }

    @Override
    public Configuration getMasterConfiguration() {
        return MasterRuntimeContext.getConfiguration();
    }

    @Override
    public String getWebUrl() {
        DispatcherGateway dispatcher = MasterRuntimeContext.getDispatcherGateway();
        String host = dispatcher.getAddress();
        int begin = host.indexOf("@") + 1;
        int end = host.indexOf(":", begin);
        host = host.substring(begin, end);
        int port = MasterRuntimeContext.getConfiguration().getInteger((ConfigOption<Integer>)RestOptions.PORT);
        return "http://" + host + ":" + port;
    }

    @Override
    public Object submitJob(Object job, int timeoutSeconds) {
        Configuration configuration = MasterRuntimeContext.getConfiguration();
        DispatcherGateway dispatcher = MasterRuntimeContext.getDispatcherGateway();
        if (job instanceof byte[]) {
            JobGraph jobGraph = (JobGraph)ObjectSerde.fromBytes((byte[])job);
            return ClusterClientMan.submitJob(jobGraph, configuration, dispatcher, timeoutSeconds);
        }
        if (job instanceof JobGraph) {
            return ClusterClientMan.submitJob((JobGraph)job, configuration, dispatcher, timeoutSeconds);
        }
        if (job instanceof JobContext) {
            return ClusterClientMan.submitJob((JobContext)job, configuration, dispatcher, timeoutSeconds, false);
        }
        throw new AlgoException("Not support job type:" + job.getClass());
    }
}

