/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.runtime.highavailability.redis;

import java.util.concurrent.Executor;
import kd.bos.algox.flink.runtime.highavailability.redis.configuration.RedisHighAvailabilityOptions;
import kd.bos.algox.flink.runtime.highavailability.redis.leaderelection.RedisLeaderElectionDriverFactory;
import kd.bos.algox.flink.runtime.highavailability.redis.leaderretrieval.RedisLeaderRetrievalDriverFactory;
import kd.bos.algox.flink.runtime.highavailability.redis.store.RedisCheckPointRecoveryFactory;
import kd.bos.algox.flink.runtime.highavailability.redis.store.RedisJobGraphStoreUtil;
import kd.bos.algox.flink.runtime.highavailability.redis.store.RedisRunningJobsRegistry;
import kd.bos.algox.flink.runtime.highavailability.redis.store.RedisStateHandleStore;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.AbstractHaServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.DefaultJobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphStoreWatcher;
import org.apache.flink.runtime.jobmanager.NoOpJobGraphStoreWatcher;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.DefaultLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;

public class RedisHaService
extends AbstractHaServices {
    private static final String RESOURCE_MANAGER_LEADER = "flink.%s.resourceManager.leader";
    private static final String DISPATCHER_LEADER = "flink.%s.dispatcher.leader";
    public static final String JOB_MANAGER_LEADER = "flink.%s.jobManager.leader.%s";
    private static final String REST_SERVER_LEADER = "flink.%s.restServer.leader";
    private String nameSpace;

    public RedisHaService(Configuration config, Executor ioExecutor, BlobStoreService blobStoreService) {
        super(config, ioExecutor, blobStoreService);
        this.nameSpace = config.getValue(HighAvailabilityOptions.HA_CLUSTER_ID);
    }

    public static final JedisClient getHaRedisModeClient(Configuration config) {
        String redisUrl = config.getString(RedisHighAvailabilityOptions.HA_REDIS_URL);
        return RedisFactory.getJedisClient((String)redisUrl);
    }

    protected LeaderElectionService createLeaderElectionService(String leaderName) {
        return new DefaultLeaderElectionService((LeaderElectionDriverFactory)new RedisLeaderElectionDriverFactory(this.configuration, leaderName));
    }

    protected LeaderRetrievalService createLeaderRetrievalService(String leaderName) {
        return new DefaultLeaderRetrievalService((LeaderRetrievalDriverFactory)new RedisLeaderRetrievalDriverFactory(this.configuration, leaderName));
    }

    protected CheckpointRecoveryFactory createCheckpointRecoveryFactory() {
        return new RedisCheckPointRecoveryFactory(this.configuration, this.ioExecutor);
    }

    protected JobGraphStore createJobGraphStore() throws Exception {
        RedisStateHandleStore<JobGraph> stateHandleStore = RedisStateHandleStore.createJobGraphStateHandleStore(this.configuration);
        return new DefaultJobGraphStore(stateHandleStore, (JobGraphStoreWatcher)NoOpJobGraphStoreWatcher.INSTANCE, RedisJobGraphStoreUtil.INSTANCE);
    }

    protected RunningJobsRegistry createRunningJobsRegistry() {
        return new RedisRunningJobsRegistry(this.configuration);
    }

    protected void internalClose() {
    }

    protected void internalCleanup() throws Exception {
    }

    protected void internalCleanupJobData(JobID jobID) throws Exception {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.del(this.getLeaderNameForJobManager(jobID));
        }
    }

    protected String getLeaderNameForResourceManager() {
        return String.format(RESOURCE_MANAGER_LEADER, this.nameSpace);
    }

    protected String getLeaderNameForDispatcher() {
        return String.format(DISPATCHER_LEADER, this.nameSpace);
    }

    protected String getLeaderNameForJobManager(JobID jobID) {
        return String.format(JOB_MANAGER_LEADER, this.nameSpace, jobID);
    }

    protected String getLeaderNameForRestServer() {
        return String.format(REST_SERVER_LEADER, this.nameSpace);
    }
}

