/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.runtime.highavailability.redis.leaderelection;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import kd.bos.algox.flink.runtime.highavailability.redis.RedisHaService;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.instance.Instance;
import kd.bos.redis.JedisClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderElectionException;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.rpc.FatalErrorHandler;

public class RedisLeaderElectionDriver
implements LeaderElectionDriver,
ElectorListener {
    private static final String INSTANCE_ID = Instance.getInstanceId();
    private final Elector elector;
    private final Configuration configuration;
    private final LeaderElectionEventHandler leaderElectionEventHandler;
    private final String leaderName;
    private final FatalErrorHandler fatalErrorHandler;
    private volatile boolean running;

    public RedisLeaderElectionDriver(Configuration configuration, String leaderName, LeaderElectionEventHandler leaderElectionEventHandler, FatalErrorHandler fatalErrorHandler, String leaderContenderDescription) {
        this.configuration = configuration;
        this.leaderElectionEventHandler = leaderElectionEventHandler;
        this.leaderName = leaderName;
        this.fatalErrorHandler = fatalErrorHandler;
        this.elector = ElectFactory.getElector((String)leaderName);
        this.elector.registerListener((ElectorListener)this);
        this.elector.start();
        this.running = true;
    }

    public void writeLeaderInformation(LeaderInformation leaderInformation) {
        assert (this.running);
        if (leaderInformation.isEmpty()) {
            return;
        }
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeUTF(INSTANCE_ID);
            oos.writeUTF(leaderInformation.getLeaderAddress());
            oos.writeObject(leaderInformation.getLeaderSessionID());
            oos.close();
            boolean dataWritten = false;
            while (!dataWritten && this.hasLeadership()) {
                byte[] keyBytes = this.leaderName.getBytes();
                byte[] data = client.get(keyBytes);
                if (data != null) {
                    String instanceId = this.elector.getMaster().getInstanceId();
                    if (INSTANCE_ID.equals(instanceId)) {
                        client.set(keyBytes, baos.toByteArray());
                        dataWritten = true;
                        continue;
                    }
                    client.del(keyBytes);
                    continue;
                }
                client.set(keyBytes, baos.toByteArray());
                dataWritten = true;
            }
        }
        catch (Exception e) {
            this.fatalErrorHandler.onFatalError((Throwable)new LeaderElectionException("Could not write leader address and leader session ID to Redis.", (Throwable)e));
        }
    }

    public boolean hasLeadership() {
        assert (this.running);
        return this.elector.getMaster() != null;
    }

    public void close() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.elector.unRegisterListener((ElectorListener)this);
        this.elector.close();
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.del(this.leaderName);
        }
    }

    public void notifyMaster() {
        this.leaderElectionEventHandler.onGrantLeadership();
    }

    public void notifyLostMaster() {
        this.leaderElectionEventHandler.onRevokeLeadership();
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            byte[] data = client.get(this.leaderName.getBytes());
            if (data != null && data.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream ois = new ObjectInputStream(bais);
                String instanceId = ois.readUTF();
                String leaderAddress = ois.readUTF();
                UUID leaderSessionID = (UUID)ois.readObject();
                this.leaderElectionEventHandler.onLeaderInformationChange(LeaderInformation.known((UUID)leaderSessionID, (String)leaderAddress));
                return;
            }
            this.leaderElectionEventHandler.onLeaderInformationChange(LeaderInformation.empty());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

