/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.runtime.highavailability.redis.leaderretrieval;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algox.flink.runtime.highavailability.redis.RedisHaService;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.redis.JedisClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalEventHandler;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.ExceptionUtils;

public class RedisLeaderRetrievalDriver
implements LeaderRetrievalDriver {
    private static final ScheduledThreadPoolExecutor es = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(4, new ThreadFactory(){
        private AtomicInteger seq = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "FlinkCosmicSlaveExamineRunner-" + this.seq.getAndIncrement());
        }
    });
    private final Configuration configuration;
    private final LeaderRetrievalEventHandler leaderRetrievalEventHandler;
    private final FatalErrorHandler fatalErrorHandler;
    private ScheduledFuture<?> scheduledFuture;
    private volatile boolean running;
    private static Method isInstanceAlive;

    public RedisLeaderRetrievalDriver(Configuration configuration, String retrievalName, LeaderRetrievalEventHandler leaderRetrievalEventHandler, FatalErrorHandler fatalErrorHandler) {
        this.configuration = configuration;
        this.leaderRetrievalEventHandler = leaderRetrievalEventHandler;
        this.fatalErrorHandler = fatalErrorHandler;
        this.scheduledFuture = es.scheduleWithFixedDelay(new CosmicSlaveExamineRunner(this.configuration, retrievalName, leaderRetrievalEventHandler), 0L, 500L, TimeUnit.MILLISECONDS);
        this.running = true;
    }

    public void close() throws Exception {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    private static boolean isInstanceAlive(String instanceId) throws KDException {
        try {
            if (isInstanceAlive == null) {
                Method m = Class.forName("kd.bos.monitor.service.LivingServiceUtils").getMethod("isInstanceAlive", String.class);
                m.setAccessible(true);
                isInstanceAlive = m;
            }
            return (Boolean)isInstanceAlive.invoke(null, instanceId);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.dlock, e.getMessage(), (Throwable)e);
        }
    }

    static {
        es.setRemoveOnCancelPolicy(true);
        isInstanceAlive = null;
    }

    private class CosmicSlaveExamineRunner
    implements Runnable {
        private final Configuration configuration;
        private final String leaderName;
        private final LeaderRetrievalEventHandler leaderRetrievalEventHandler;

        public CosmicSlaveExamineRunner(Configuration configuration, String leaderName, LeaderRetrievalEventHandler leaderRetrievalEventHandler) {
            this.configuration = configuration;
            this.leaderName = leaderName;
            this.leaderRetrievalEventHandler = leaderRetrievalEventHandler;
        }

        @Override
        public void run() {
            if (RedisLeaderRetrievalDriver.this.running) {
                try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
                    byte[] data = client.get(this.leaderName.getBytes());
                    if (data != null && data.length > 0) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(data);
                        ObjectInputStream ois = new ObjectInputStream(bais);
                        String instanceId = ois.readUTF();
                        String leaderAddress = ois.readUTF();
                        UUID leaderSessionID = (UUID)ois.readObject();
                        if (RedisLeaderRetrievalDriver.isInstanceAlive(instanceId)) {
                            this.leaderRetrievalEventHandler.notifyLeaderAddress(LeaderInformation.known((UUID)leaderSessionID, (String)leaderAddress));
                        }
                        return;
                    }
                    this.leaderRetrievalEventHandler.notifyLeaderAddress(LeaderInformation.empty());
                }
                catch (Exception e) {
                    RedisLeaderRetrievalDriver.this.fatalErrorHandler.onFatalError((Throwable)new LeaderRetrievalException("Could not handle slave runner change to master.", (Throwable)e));
                    ExceptionUtils.checkInterrupted((Throwable)e);
                }
            }
        }
    }
}

