/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.runtime.highavailability.redis.store;

import java.io.IOException;
import kd.bos.algox.flink.runtime.highavailability.redis.RedisHaService;
import kd.bos.algox.flink.runtime.highavailability.redis.configuration.RedisHighAvailabilityOptions;
import kd.bos.algox.flink.runtime.highavailability.redis.store.RedisStateHandleStore;
import kd.bos.redis.JedisClient;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;

public class RedisRunningJobsRegistry
implements RunningJobsRegistry {
    private final Configuration configuration;
    private final String namespace;
    private final byte[] namespaceBytes;

    public RedisRunningJobsRegistry(Configuration configuration) {
        this.configuration = configuration;
        String runningJobPath = configuration.getString(RedisHighAvailabilityOptions.HA_REDIS_RUNNING_JOB_REGISTRY_PATH);
        this.namespace = String.format("flink.%s.%s", configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID), runningJobPath);
        this.namespaceBytes = this.namespace.getBytes(RedisStateHandleStore.ENCODING);
    }

    public void setJobRunning(JobID jobID) throws IOException {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.hset(this.namespaceBytes, jobID.toString().getBytes(RedisStateHandleStore.ENCODING), RunningJobsRegistry.JobSchedulingStatus.RUNNING.name().getBytes(RedisStateHandleStore.ENCODING));
        }
    }

    public void setJobFinished(JobID jobID) throws IOException {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.hset(this.namespaceBytes, jobID.toString().getBytes(RedisStateHandleStore.ENCODING), RunningJobsRegistry.JobSchedulingStatus.DONE.name().getBytes(RedisStateHandleStore.ENCODING));
        }
    }

    public RunningJobsRegistry.JobSchedulingStatus getJobSchedulingStatus(JobID jobID) throws IOException {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            byte[] data = client.hget(this.namespaceBytes, jobID.toString().getBytes(RedisStateHandleStore.ENCODING));
            if (data != null) {
                RunningJobsRegistry.JobSchedulingStatus jobSchedulingStatus = RunningJobsRegistry.JobSchedulingStatus.valueOf((String)new String(data, RedisStateHandleStore.ENCODING));
                return jobSchedulingStatus;
            }
        }
        return RunningJobsRegistry.JobSchedulingStatus.PENDING;
    }

    public void clearJob(JobID jobID) throws IOException {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.hdel(this.namespaceBytes, (byte[][])new byte[][]{jobID.toString().getBytes(RedisStateHandleStore.ENCODING)});
        }
    }
}

