/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.runtime.highavailability.redis.store;

import com.tongtech.backport.java.util.Arrays;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.algox.AlgoXException;
import kd.bos.algox.flink.runtime.highavailability.redis.RedisHaService;
import kd.bos.algox.flink.runtime.highavailability.redis.configuration.RedisHighAvailabilityOptions;
import kd.bos.algox.flink.runtime.highavailability.redis.store.RedisJobGraphStoreUtil;
import kd.bos.redis.JedisClient;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.persistence.PossibleInconsistentStateException;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.StateHandleStore;
import org.apache.flink.runtime.persistence.StringResourceVersion;
import org.apache.flink.runtime.persistence.filesystem.FileSystemStateStorageHelper;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.util.StateHandleStoreUtils;
import org.apache.flink.util.Preconditions;

public class RedisStateHandleStore<T extends Serializable>
implements StateHandleStore<T, StringResourceVersion> {
    private static final String HA_STORAGE_SUBMITTED_JOBGRAPH_PREFIX = "submittedJobGraph";
    private static final String VERSION_SUFFIX = "-version";
    static final Charset ENCODING = Charset.forName("UTF-8");
    private final Configuration configuration;
    private final RetrievableStateStorageHelper stateStorage;
    private final String namespace;
    private final byte[] namespaceBytes;
    private final String versionNamespace;

    public RedisStateHandleStore(Configuration configuration, RetrievableStateStorageHelper<T> stateStorage, String namespace) {
        this.configuration = configuration;
        this.stateStorage = stateStorage;
        this.namespace = namespace;
        this.namespaceBytes = namespace.getBytes(ENCODING);
        this.versionNamespace = namespace + VERSION_SUFFIX;
    }

    public static RedisStateHandleStore<JobGraph> createJobGraphStateHandleStore(Configuration configuration) throws IOException {
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration");
        FileSystemStateStorageHelper stateStorage = new FileSystemStateStorageHelper(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)configuration), HA_STORAGE_SUBMITTED_JOBGRAPH_PREFIX);
        String clusterId = configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID);
        String jobGraphsPath = configuration.getString(RedisHighAvailabilityOptions.HA_REDIS_JOBGRAPHS_PATH);
        return new RedisStateHandleStore<JobGraph>(configuration, (RetrievableStateStorageHelper<JobGraph>)stateStorage, String.format("flink.%s.%s", clusterId, jobGraphsPath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RetrievableStateHandle<T> addAndLock(String name, T state) throws PossibleInconsistentStateException, Exception {
        RetrievableStateHandle storeHandle = this.stateStorage.store(state);
        byte[] serializedStoreHandle = StateHandleStoreUtils.serializeOrDiscard((StateObject)storeHandle);
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.hset(this.namespaceBytes, name.getBytes(ENCODING), serializedStoreHandle);
            client.hincrBy(this.versionNamespace, name, 1L);
            RetrievableStateHandle retrievableStateHandle = storeHandle;
            return retrievableStateHandle;
        }
        catch (Exception e) {
            storeHandle.discardState();
            throw new AlgoXException((Throwable)e);
        }
    }

    public void replace(String name, StringResourceVersion stringResourceVersion, T state) throws PossibleInconsistentStateException, Exception {
        Preconditions.checkNotNull((Object)name, (String)"Name in Redis");
        Preconditions.checkNotNull(state, (String)"State");
        RetrievableStateHandle<T> oldStateHandle = this.getAndLock(name);
        RetrievableStateHandle newStateHandle = this.stateStorage.store(state);
        byte[] serializedStateHandle = StateHandleStoreUtils.serializeOrDiscard((StateObject)newStateHandle);
        boolean discardOldState = true;
        boolean discardNewState = false;
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.hset(this.namespaceBytes, name.getBytes(ENCODING), serializedStateHandle);
            client.hset(this.versionNamespace, name, stringResourceVersion.getValue());
            discardOldState = true;
            discardNewState = false;
        }
        catch (Exception e) {
            throw new AlgoXException((Throwable)e);
        }
        finally {
            if (discardOldState) {
                oldStateHandle.discardState();
            }
            if (discardNewState) {
                newStateHandle.discardState();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringResourceVersion exists(String name) throws Exception {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            String v = client.hget(this.versionNamespace, name);
            StringResourceVersion stringResourceVersion = StringResourceVersion.valueOf((String)v);
            return stringResourceVersion;
        }
        catch (Exception e) {
            return StringResourceVersion.notExisting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RetrievableStateHandle<T> getAndLock(String name) throws Exception {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            RetrievableStateHandle retrievableStateHandle;
            byte[] value = client.hget(this.namespaceBytes, name.getBytes(ENCODING));
            RetrievableStateHandle retrievableStateHandle2 = retrievableStateHandle = (RetrievableStateHandle)StateHandleStoreUtils.deserialize((byte[])value);
            return retrievableStateHandle2;
        }
        catch (Exception e) {
            throw new AlgoXException((Throwable)e);
        }
    }

    public List<Tuple2<RetrievableStateHandle<T>, String>> getAllAndLock() throws Exception {
        ArrayList<Tuple2<RetrievableStateHandle<T>, String>> stateHandles = new ArrayList<Tuple2<RetrievableStateHandle<T>, String>>();
        boolean succeed = false;
        while (!succeed) {
            Collection<String> handles = this.getAllHandles();
            int initNum = handles.size();
            for (String handle : handles) {
                RetrievableStateHandle<T> stateHandle = this.getAndLock(handle);
                stateHandles.add(new Tuple2(stateHandle, (Object)handle));
            }
            JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);
            Throwable throwable = null;
            try {
                Long hLen = client.hlen(this.namespaceBytes);
                succeed = (long)initNum == hLen;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                client.close();
            }
        }
        return stateHandles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<String> getAllHandles() throws Exception {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            List list = Arrays.asList((Object[])client.hkeys(this.namespace).toArray(new String[0]));
            return list;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public boolean releaseAndTryRemove(String name) throws Exception {
        Preconditions.checkNotNull((Object)name, (String)"Name in Redis");
        RetrievableStateHandle<T> stateHandle = this.getAndLock(name);
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.hdel(this.namespace, new String[]{name});
            client.hdel(this.versionNamespace, new String[]{name});
        }
        catch (Exception e) {
            return false;
        }
        if (stateHandle != null) {
            stateHandle.discardState();
        }
        return true;
    }

    public void releaseAndTryRemoveAll() throws Exception {
        Collection<String> allHandles = this.getAllHandles();
        for (String handle : allHandles) {
            this.releaseAndTryRemove(handle);
        }
    }

    public void clearEntries() throws Exception {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.del(this.namespace);
            client.del(this.versionNamespace);
        }
    }

    public void release(String name) throws Exception {
        try (JedisClient client = RedisHaService.getHaRedisModeClient(this.configuration);){
            client.hdel(this.namespace, new String[]{name});
            client.hdel(this.versionNamespace, new String[]{name});
            client.del(String.format("flink.%s.jobManager.leader.%s", this.configuration.getString((ConfigOption<String>)HighAvailabilityOptions.HA_CLUSTER_ID), RedisJobGraphStoreUtil.INSTANCE.nameToJobID(name)));
        }
    }

    public void releaseAll() throws Exception {
        Collection<String> allHandles = this.getAllHandles();
        for (String name : allHandles) {
            this.release(name);
        }
    }
}

