/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.type;

import java.io.DataInput;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.StringValue;

@Internal
public final class NStringComparator
extends BasicTypeComparator<String> {
    private static final long serialVersionUID = 1L;
    private static final int HIGH_BIT = 128;
    private static final int HIGH_BIT2 = 8192;
    private static final int HIGH_BIT2_MASK = 192;
    private static Collator collator = Collator.getInstance(Locale.CHINA);

    public NStringComparator(boolean ascending) {
        super(ascending);
    }

    public int compare(String first, String second) {
        int cmp = collator.compare(first, second);
        return this.ascendingComparison ? cmp : -cmp;
    }

    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        String s1 = StringValue.readString((DataInput)firstSource);
        String s2 = StringValue.readString((DataInput)secondSource);
        int comp = collator.compare(s1, s2);
        return this.ascendingComparison ? comp : -comp;
    }

    public boolean supportsNormalizedKey() {
        return false;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public int getNormalizeKeyLen() {
        return Integer.MAX_VALUE;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return true;
    }

    public void putNormalizedKey(String record, MemorySegment target, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public NStringComparator duplicate() {
        return new NStringComparator(this.ascendingComparison);
    }
}

