/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.type;

import java.io.IOException;
import kd.bos.algox.RowX;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public class NullMaskUtils {
    public static void writeNullMask(int len, RowX value, DataOutputView target) throws IOException {
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = 0;
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                b <<= 1;
                if (value.get(fieldPos + bytePos) != null) continue;
                b |= 1;
            }
            target.writeByte(b <<= 8 - bytePos);
        }
    }

    public static void readIntoNullMask(int len, DataInputView source, boolean[] nullMask) throws IOException {
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = source.readUnsignedByte();
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                nullMask[fieldPos + bytePos] = (b & 0x80) > 0;
                b <<= 1;
            }
        }
    }

    public static void readIntoAndCopyNullMask(int len, DataInputView source, DataOutputView target, boolean[] nullMask) throws IOException {
        int b = 0;
        int bytePos = 0;
        int numPos = 0;
        for (int fieldPos = 0; fieldPos < len; fieldPos += numPos) {
            b = source.readUnsignedByte();
            target.writeByte(b);
            numPos = Math.min(8, len - fieldPos);
            for (bytePos = 0; bytePos < numPos; ++bytePos) {
                nullMask[fieldPos + bytePos] = (b & 0x80) > 0;
                b <<= 1;
            }
        }
    }
}

